/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public final class ReflectionObjects {
    private ReflectionObjects() {
    }

    public static boolean isEmptyObject(Object obj) {
        return ReflectionObjects.getObjectProperties(obj, true).isEmpty();
    }

    public static Map<String, Object> getObjectProperties(Object obj) {
        return ReflectionObjects.getObjectProperties(obj, false);
    }

    public static Map<String, Object> getObjectProperties(Object obj, boolean onlyTakeFirstValue) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (Class<?> clazz = obj.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                Object value;
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
                try {
                    if (Modifier.isPublic(field.getModifiers())) {
                        value = field.get(obj);
                    } else {
                        field.setAccessible(true);
                        value = field.get(obj);
                    }
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
                if (value == null) continue;
                properties.put(field.getName(), value);
                if (!onlyTakeFirstValue) continue;
                return properties;
            }
        }
        return properties;
    }
}

