/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.binding.impl;

import com.tvd12.ezyfox.asm.EzyFunction;
import com.tvd12.ezyfox.asm.EzyInstruction;
import com.tvd12.ezyfox.binding.annotation.EzyArrayBinding;
import com.tvd12.ezyfox.binding.impl.EzyAbstractReaderBuilder;
import com.tvd12.ezyfox.binding.impl.EzyArrayElementsFetcher;
import com.tvd12.ezyfox.binding.impl.EzyElementsFetcher;
import com.tvd12.ezyfox.entity.EzyArray;
import com.tvd12.ezyfox.reflect.EzyClass;
import com.tvd12.ezyfox.reflect.EzyField;
import com.tvd12.ezyfox.reflect.EzyGenericSetterValidator;
import com.tvd12.ezyfox.reflect.EzyGenerics;
import com.tvd12.ezyfox.reflect.EzyMethod;
import com.tvd12.ezyfox.reflect.EzyReflectElement;
import com.tvd12.ezyfox.reflect.EzySetterMethod;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;

public class EzyArrayReaderBuilder
extends EzyAbstractReaderBuilder {
    protected static final AtomicInteger COUNT = new AtomicInteger(0);
    protected static boolean debug;

    public EzyArrayReaderBuilder(EzyClass clazz) {
        super(clazz);
    }

    @Override
    protected int getAccessType(EzyClass clazz) {
        EzyArrayBinding ann = (EzyArrayBinding)clazz.getAnnotation(EzyArrayBinding.class);
        return ann == null ? 3 : ann.accessType();
    }

    @Override
    protected EzyElementsFetcher newElementsFetcher() {
        return new EzyArrayReaderElementsFetcher();
    }

    @Override
    protected String makeImplMethodContent(EzyMethod readMethod) {
        EzyFunction.EzyBody methodBody = new EzyFunction(readMethod).modifier("protected").body().append(new EzyInstruction("\t", "\n").variable(EzyArray.class, "value").equal().cast(EzyArray.class, "arg1"));
        this.appendOutputObjectConstructor(methodBody);
        List<Object> elements = this.getElements();
        for (int index = 0; index < elements.size(); ++index) {
            EzyInstruction unmarshalInstruction;
            EzyInstruction instruction;
            Object element = elements.get(index);
            if (element == null || element instanceof EzyField && !((EzyField)element).isWritable()) continue;
            methodBody.append(this.checkNotNullInstruction(index));
            if (element instanceof EzyField) {
                EzyField field = (EzyField)element;
                instruction = new EzyInstruction("\t\t", "\n").append("object").dot().append(field.getName()).equal();
                unmarshalInstruction = this.newUnmarshalInstruction((EzyReflectElement)field, index);
                instruction.append(unmarshalInstruction.toString());
            } else {
                EzySetterMethod method = (EzySetterMethod)element;
                instruction = new EzyInstruction("\t\t", "\n").append("object").dot().append(method.getName()).bracketopen();
                unmarshalInstruction = this.newUnmarshalInstruction((EzyReflectElement)method, index);
                instruction.append(unmarshalInstruction.toString()).bracketclose();
            }
            methodBody.append(instruction);
        }
        this.addPostReadMethods(methodBody);
        methodBody.append(new EzyInstruction("\t", "\n").answer().append("object"));
        EzyFunction method = methodBody.function();
        return method.toString();
    }

    protected EzyInstruction checkNotNullInstruction(int index) {
        return new EzyInstruction("\t", "\n", false).append("if").bracketopen().append("value").dot().append("isNotNullValue").bracketopen().append((Object)index).bracketclose().bracketclose();
    }

    protected EzyInstruction newUnmarshalInstruction(EzyReflectElement element, int index) {
        Set<Class> commonGenericTypes = this.getCommonGenericTypes();
        Class type = this.getElementType(element);
        Class readerImpl = this.getReaderImplClass(element);
        EzyInstruction instruction = readerImpl != null || !commonGenericTypes.contains(type) ? this.newUnmarshalNormalInstruction(element, readerImpl, index) : this.newUnmarshalGenericInstruction(element, index);
        return this.wrapUnmarshalInstruction(instruction, type);
    }

    protected EzyInstruction newUnmarshalGenericInstruction(EzyReflectElement element, int index) {
        Class genericType = this.getElementType(element);
        if (Map.class.isAssignableFrom(genericType)) {
            return this.newUnmarshalMapInstruction(element, index);
        }
        return this.newUnmarshalCollectionInstruction(element, index);
    }

    protected EzyInstruction newUnmarshalMapInstruction(EzyReflectElement element, int index) {
        Class mapType = this.getElementType(element);
        Type genericType = this.getElementGenericType(element);
        Class[] keyValueTypes = EzyGenerics.getTwoGenericClassArguments((Type)genericType);
        return new EzyInstruction("", "", false).append("arg0.unmarshalMap").bracketopen().bracketopen().clazz(Object.class).bracketclose().append("value.getValue(").append((Object)index).comma().clazz(mapType, true).bracketclose().comma().clazz(mapType, true).comma().clazz(keyValueTypes[0], true).comma().clazz(keyValueTypes[1], true).bracketclose();
    }

    protected EzyInstruction newUnmarshalCollectionInstruction(EzyReflectElement element, int index) {
        Class collectionType = this.getElementType(element);
        Type genericType = this.getElementGenericType(element);
        Class itemType = EzyGenerics.getOneGenericClassArgument((Type)genericType);
        return new EzyInstruction("", "", false).append("arg0.unmarshalCollection").bracketopen().bracketopen().clazz(Object.class).bracketclose().append("value.getValue(").append((Object)index).comma().clazz(collectionType, true).bracketclose().comma().clazz(collectionType, true).comma().clazz(itemType, true).bracketclose();
    }

    protected EzyInstruction newUnmarshalNormalInstruction(EzyReflectElement element, Class readerImpl, int index) {
        EzyInstruction instruction = new EzyInstruction("", "", false).append("arg0.unmarshal").bracketopen();
        if (readerImpl != null) {
            instruction.clazz(readerImpl, true).comma();
        }
        Class type = this.getElementType(element);
        instruction.bracketopen().clazz(Object.class).bracketclose().append("value.getValue(").append((Object)index).comma().clazz(type, true).bracketclose();
        if (readerImpl == null) {
            instruction.comma().clazz(type, true);
        }
        instruction.bracketclose();
        return instruction;
    }

    @Override
    protected void appendConstructorParamValue(EzyInstruction instruction, Parameter parameter, int parameterIndex, EzyField field, String key) {
        instruction.append("value").dot().append("isNotNullValue").bracketopen().append((Object)parameterIndex).bracketclose().append(" ? ").append(this.newUnmarshalInstruction((EzyReflectElement)field, parameterIndex)).append(" : ").defaultValue(parameter.getType());
    }

    @Override
    protected String getImplClassName() {
        return this.clazz.getName() + "$EzyArrayReader$EzyAutoImpl$" + COUNT.incrementAndGet();
    }

    @Override
    protected boolean isDebug() {
        return debug;
    }

    @Generated
    public static void setDebug(boolean debug) {
        EzyArrayReaderBuilder.debug = debug;
    }

    public static class EzyArrayReaderElementsFetcher
    extends EzyArrayElementsFetcher {
        private final EzyGenericSetterValidator setterValidator = new EzyGenericSetterValidator();

        @Override
        protected List<? extends EzyMethod> getMethodList(EzyClass clazz) {
            return clazz.getSetterMethods();
        }

        @Override
        protected List<? extends EzyMethod> getDeclaredMethods(EzyClass clazz) {
            return clazz.getDeclaredSetterMethods();
        }

        @Override
        protected boolean isValidGenericField(EzyField field) {
            return this.setterValidator.validate(field.getGenericType());
        }

        @Override
        protected boolean isValidGenericMethod(EzyMethod method) {
            return this.setterValidator.validate(((EzySetterMethod)method).getGenericType());
        }

        @Override
        protected EzyMethod newByFieldMethod(EzyMethod method) {
            return new EzySetterMethod(method);
        }

        @Override
        protected boolean isValidAnnotatedMethod(EzyMethod method) {
            return method.getParameterCount() == 1;
        }
    }
}

