/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.web.controller.decorator;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.model.LetterReceiverModel;
import org.youngmonkeys.ezyplatform.model.MediaNameModel;
import org.youngmonkeys.ezyplatform.model.PaginationModel;
import org.youngmonkeys.ezyplatform.model.SimpleLetterModel;
import org.youngmonkeys.ezyplatform.model.UserModel;
import org.youngmonkeys.ezyplatform.web.converter.WebModelToResponseConverter;
import org.youngmonkeys.ezyplatform.web.response.LetterResponse;
import org.youngmonkeys.ezyplatform.web.service.WebLetterService;
import org.youngmonkeys.ezyplatform.web.service.WebMediaService;
import org.youngmonkeys.ezyplatform.web.service.WebUserService;

@EzySingleton
public class WebLetterModelDecorator {
    private final WebMediaService mediaService;
    private final WebLetterService letterService;
    private final WebUserService userService;
    private final WebModelToResponseConverter modelToResponseConverter;

    public PaginationModel<LetterResponse> decorate(PaginationModel<LetterReceiverModel> pagination) {
        List models = pagination.getItems();
        Set letterIds = models.stream().map(LetterReceiverModel::getLetterId).filter(it -> it > 0L).collect(Collectors.toSet());
        Map letterById = this.letterService.getLetterMapByIds(letterIds);
        Set fromUserIds = letterById.values().stream().map(SimpleLetterModel::getFromUserId).filter(it -> it > 0L).collect(Collectors.toSet());
        Map fromUserById = this.userService.getUserMapByIds(fromUserIds);
        Set fromUserAvatarIds = fromUserById.values().stream().map(UserModel::getAvatarImageId).filter(it -> it > 0L).collect(Collectors.toSet());
        Map fromUserAvatarById = this.mediaService.getMediaNameMapByIds(fromUserAvatarIds);
        return pagination.map(it -> {
            SimpleLetterModel letter = letterById.getOrDefault(it.getLetterId(), SimpleLetterModel.builder().build());
            UserModel fromUser = (UserModel)fromUserById.get(letter.getFromUserId());
            MediaNameModel fromUserAvatar = fromUser == null ? null : (MediaNameModel)fromUserAvatarById.get(fromUser.getAvatarImageId());
            return this.modelToResponseConverter.toResponse(letter, (LetterReceiverModel)it, fromUser, fromUserAvatar);
        });
    }

    @Generated
    public WebLetterModelDecorator(WebMediaService mediaService, WebLetterService letterService, WebUserService userService, WebModelToResponseConverter modelToResponseConverter) {
        this.mediaService = mediaService;
        this.letterService = letterService;
        this.userService = userService;
        this.modelToResponseConverter = modelToResponseConverter;
    }
}

