/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.core.io;

import com.tvd12.ezyfox.function.EzyExceptionFunction;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

public class AnywayFileLoader {
    private final List<Function<String, File>> loaders = Arrays.asList(File::new, filePath -> this.newFileFromUrl(this.getClass().getResource((String)filePath)), filePath -> this.newFileFromUrl(this.getClass().getClassLoader().getResource((String)filePath)), filePath -> this.newFileFromUrl(this.getClass().getResource('/' + filePath)), filePath -> this.newFileFromUrl(this.getClass().getClassLoader().getResource('/' + filePath)), filePath -> this.newFileFromUrl(Thread.currentThread().getContextClassLoader().getResource((String)filePath)), filePath -> this.newFileFromUrl(Thread.currentThread().getContextClassLoader().getResource('/' + filePath)));
    private final List<EzyExceptionFunction<URL, File>> fileCreators = Arrays.asList(url -> new File(url.getFile()), url -> new File(url.toURI()));
    private static final AnywayFileLoader DEFAULT = new AnywayFileLoader();

    public static AnywayFileLoader getDefault() {
        return DEFAULT;
    }

    public File load(String filePath) {
        for (Function<String, File> loader : this.loaders) {
            File file = loader.apply(filePath);
            if (file == null || !file.exists()) continue;
            return file;
        }
        return null;
    }

    private File newFileFromUrl(URL fileUrl) {
        if (fileUrl == null) {
            return null;
        }
        for (EzyExceptionFunction<URL, File> creator : this.fileCreators) {
            try {
                File file = (File)creator.apply((Object)fileUrl);
                if (!file.exists()) continue;
                return file;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }
}

