/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.pagination;

import com.tvd12.ezydata.database.query.EzyQueryConditionBuilder;
import com.tvd12.ezyfox.builder.EzyBuilder;
import java.util.Collection;
import org.youngmonkeys.ezyplatform.entity.AdminStatus;
import org.youngmonkeys.ezyplatform.pagination.AdminFilter;

public class DefaultAdminFilter
implements AdminFilter {
    public final Collection<Long> ids;
    public final AdminStatus status;
    public final Collection<AdminStatus> statuses;
    public final AdminStatus exclusiveStatus;
    public final String uniqueKeyword;
    public final String likeKeyword;
    public final Long roleId;
    public final Collection<Long> roleIds;
    public final String roleName;
    public final Collection<String> roleNames;
    public final Long exclusiveRoleId;
    public final Collection<Long> exclusiveRoleIds;
    public final String exclusiveRoleName;
    public final Collection<String> exclusiveRoleNames;

    protected DefaultAdminFilter(Builder<?> builder) {
        this.ids = ((Builder)builder).ids;
        this.status = ((Builder)builder).status;
        this.statuses = ((Builder)builder).statuses;
        this.exclusiveStatus = ((Builder)builder).exclusiveStatus;
        this.uniqueKeyword = ((Builder)builder).uniqueKeyword;
        this.likeKeyword = ((Builder)builder).likeKeyword;
        this.roleId = ((Builder)builder).roleId;
        this.roleIds = ((Builder)builder).roleIds;
        this.roleName = ((Builder)builder).roleName;
        this.roleNames = ((Builder)builder).roleNames;
        this.exclusiveRoleId = ((Builder)builder).exclusiveRoleId;
        this.exclusiveRoleIds = ((Builder)builder).exclusiveRoleIds;
        this.exclusiveRoleName = ((Builder)builder).exclusiveRoleName;
        this.exclusiveRoleNames = ((Builder)builder).exclusiveRoleNames;
    }

    public void decorateQueryStringBeforeWhere(StringBuilder queryString) {
        if (this.roleId != null || this.roleIds != null || this.roleName != null || this.roleNames != null) {
            queryString.append(" INNER JOIN AdminRole l ON e.id = l.adminId");
            if (this.roleName != null || this.roleNames != null) {
                queryString.append(" INNER JOIN AdminRoleName m ON m.id = l.roleId");
            }
        }
        if (this.exclusiveRoleId != null || this.exclusiveRoleName != null || this.exclusiveRoleIds != null || this.exclusiveRoleNames != null) {
            queryString.append(" LEFT JOIN AdminRole l ON e.id = l.adminId");
            if (this.exclusiveRoleId != null) {
                queryString.append(" AND l.roleId = :exclusiveRoleId");
            }
            if (this.exclusiveRoleIds != null) {
                queryString.append(" AND l.roleId IN :exclusiveRoleIds");
            }
            if (this.exclusiveRoleName != null || this.exclusiveRoleNames != null) {
                queryString.append(" LEFT JOIN AdminRoleName m ON m.id = l.roleId");
                if (this.exclusiveRoleName != null) {
                    queryString.append(" AND m.name = :exclusiveRoleName");
                }
                if (this.exclusiveRoleNames != null) {
                    queryString.append(" AND m.name IN :exclusiveRoleNames");
                }
            }
        }
    }

    public String matchingCondition() {
        EzyQueryConditionBuilder answer = new EzyQueryConditionBuilder();
        if (this.ids != null) {
            answer.and("e.id IN :ids");
        }
        if (this.status != null) {
            answer.and("e.status = :status");
        }
        if (this.statuses != null) {
            answer.and("e.status IN :statuses");
        }
        if (this.exclusiveStatus != null) {
            answer.and("e.status <> :exclusiveStatus");
        }
        if (this.roleId != null) {
            answer.and("l.roleId = :roleId");
        }
        if (this.roleIds != null) {
            answer.and("l.roleId IN :roleIds");
        }
        if (this.roleName != null) {
            answer.and("m.name = :roleName");
        }
        if (this.roleNames != null) {
            answer.and("m.name IN :roleNames");
        }
        if (this.exclusiveRoleId != null || this.exclusiveRoleIds != null) {
            answer.and("l.roleId IS NULL");
        }
        if (this.exclusiveRoleName != null || this.exclusiveRoleNames != null) {
            answer.and("m.id IS NULL");
        }
        if (this.uniqueKeyword != null) {
            answer.and(new EzyQueryConditionBuilder().append("(").append("e.username = :uniqueKeyword").or("e.phone = :uniqueKeyword").or("e.email = :uniqueKeyword").or("e.uuid = :uniqueKeyword").or("e.id = :uniqueKeyword").append(")").build());
        }
        if (this.likeKeyword != null) {
            answer.and(new EzyQueryConditionBuilder().append("(").append("e.phone LIKE CONCAT('%',:likeKeyword,'%')").or("e.email LIKE CONCAT('%',:likeKeyword,'%')").or("e.displayName LIKE CONCAT('%',:likeKeyword,'%')").or("e.username LIKE CONCAT('%',:likeKeyword,'%')").append(")").build());
        }
        return answer.build();
    }

    public static class Builder<T extends Builder<T>>
    implements EzyBuilder<DefaultAdminFilter> {
        private Collection<Long> ids;
        private AdminStatus status;
        private Collection<AdminStatus> statuses;
        private AdminStatus exclusiveStatus;
        private String uniqueKeyword;
        private String likeKeyword;
        private Long roleId;
        private Collection<Long> roleIds;
        private String roleName;
        private Collection<String> roleNames;
        private Long exclusiveRoleId;
        private Collection<Long> exclusiveRoleIds;
        private String exclusiveRoleName;
        private Collection<String> exclusiveRoleNames;

        public T ids(Collection<Long> ids) {
            this.ids = ids;
            return (T)this;
        }

        public T status(AdminStatus status) {
            this.status = status;
            return (T)this;
        }

        public T statuses(Collection<AdminStatus> statuses) {
            this.statuses = statuses;
            return (T)this;
        }

        public T exclusiveStatus(AdminStatus exclusiveStatus) {
            this.exclusiveStatus = exclusiveStatus;
            return (T)this;
        }

        public T uniqueKeyword(String uniqueKeyword) {
            this.uniqueKeyword = uniqueKeyword;
            return (T)this;
        }

        public T likeKeyword(String likeKeyword) {
            this.likeKeyword = likeKeyword;
            return (T)this;
        }

        public T roleId(Long roleId) {
            this.roleId = roleId;
            return (T)this;
        }

        public T roleIds(Collection<Long> roleIds) {
            this.roleIds = roleIds;
            return (T)this;
        }

        public T roleName(String roleName) {
            this.roleName = roleName;
            return (T)this;
        }

        public T roleNames(Collection<String> roleNames) {
            this.roleNames = roleNames;
            return (T)this;
        }

        public T exclusiveRoleId(Long exclusiveRoleId) {
            this.exclusiveRoleId = exclusiveRoleId;
            return (T)this;
        }

        public T exclusiveRoleIds(Collection<Long> exclusiveRoleIds) {
            this.exclusiveRoleIds = exclusiveRoleIds;
            return (T)this;
        }

        public T exclusiveRoleName(String exclusiveRoleName) {
            this.exclusiveRoleName = exclusiveRoleName;
            return (T)this;
        }

        public T exclusiveRoleNames(Collection<String> exclusiveRoleNames) {
            this.exclusiveRoleNames = exclusiveRoleNames;
            return (T)this;
        }

        public DefaultAdminFilter build() {
            return new DefaultAdminFilter(this);
        }
    }
}

