/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.support.asm;

import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfoxserver.support.asm.EzyAsmRequestHandler;
import com.tvd12.ezyfoxserver.support.asm.EzyRequestHandlerImplementer;
import com.tvd12.ezyfoxserver.support.exception.EzyDuplicateRequestHandlerException;
import com.tvd12.ezyfoxserver.support.factory.EzyResponseFactory;
import com.tvd12.ezyfoxserver.support.handler.EzyUserRequestHandler;
import com.tvd12.ezyfoxserver.support.manager.EzyFeatureCommandManager;
import com.tvd12.ezyfoxserver.support.manager.EzyRequestCommandManager;
import com.tvd12.ezyfoxserver.support.reflect.EzyRequestControllerProxy;
import com.tvd12.ezyfoxserver.support.reflect.EzyRequestHandlerMethod;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public class EzyRequestHandlersImplementer
extends EzyLoggable {
    private boolean allowOverrideCommand;
    private EzyResponseFactory responseFactory;
    private EzyFeatureCommandManager featureCommandManager;
    private EzyRequestCommandManager requestCommandManager;

    public Map<String, EzyUserRequestHandler> implement(Collection<Object> controllers) {
        HashMap<String, EzyUserRequestHandler> handlers = new HashMap<String, EzyUserRequestHandler>();
        for (Object controller : controllers) {
            Map<String, EzyUserRequestHandler> map = this.implement(controller);
            for (String command : map.keySet()) {
                EzyUserRequestHandler handler;
                EzyUserRequestHandler old = handlers.put(command, handler = map.get(command));
                if (old == null || this.allowOverrideCommand) continue;
                throw new EzyDuplicateRequestHandlerException(command, old, handler);
            }
        }
        return handlers;
    }

    private Map<String, EzyUserRequestHandler> implement(Object controller) {
        HashMap<String, EzyUserRequestHandler> handlers = new HashMap<String, EzyUserRequestHandler>();
        EzyRequestControllerProxy proxy = new EzyRequestControllerProxy(controller);
        String feature = proxy.getFeature();
        for (EzyRequestHandlerMethod method : proxy.getRequestHandlerMethods()) {
            String methodFeature;
            EzyRequestHandlerImplementer implementer = this.newImplementer(proxy, method);
            EzyAsmRequestHandler handler = implementer.implement();
            String command = handler.getCommand();
            handlers.put(command, handler);
            this.requestCommandManager.addCommand(command);
            if (proxy.isManagement() || method.isManagement()) {
                this.requestCommandManager.addManagementCommand(command);
            }
            if (proxy.isPayment() || method.isPayment()) {
                this.requestCommandManager.addPaymentCommand(command);
            }
            if (!EzyStrings.isNotBlank((String)(methodFeature = feature != null ? feature : method.getFeature()))) continue;
            this.featureCommandManager.addFeatureCommand(methodFeature, command);
        }
        return handlers;
    }

    protected EzyRequestHandlerImplementer newImplementer(EzyRequestControllerProxy controller, EzyRequestHandlerMethod method) {
        EzyRequestHandlerImplementer implementer = new EzyRequestHandlerImplementer(controller, method);
        implementer.setResponseFactory(this.responseFactory);
        return implementer;
    }

    @Generated
    public void setAllowOverrideCommand(boolean allowOverrideCommand) {
        this.allowOverrideCommand = allowOverrideCommand;
    }

    @Generated
    public void setResponseFactory(EzyResponseFactory responseFactory) {
        this.responseFactory = responseFactory;
    }

    @Generated
    public void setFeatureCommandManager(EzyFeatureCommandManager featureCommandManager) {
        this.featureCommandManager = featureCommandManager;
    }

    @Generated
    public void setRequestCommandManager(EzyRequestCommandManager requestCommandManager) {
        this.requestCommandManager = requestCommandManager;
    }
}

