/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.support.controller;

import com.tvd12.ezyfox.annotation.EzyFeature;
import com.tvd12.ezyfox.annotation.EzyManagement;
import com.tvd12.ezyfox.annotation.EzyPayment;
import com.tvd12.ezyfox.bean.EzyBeanContext;
import com.tvd12.ezyfox.bean.EzyPrototypeFactory;
import com.tvd12.ezyfox.bean.EzyPrototypeSupplier;
import com.tvd12.ezyfox.binding.EzyDataBinding;
import com.tvd12.ezyfox.binding.EzyUnmarshaller;
import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.core.annotation.EzyRequestListener;
import com.tvd12.ezyfox.core.exception.EzyBadRequestException;
import com.tvd12.ezyfox.core.util.EzyRequestListenerAnnotations;
import com.tvd12.ezyfox.entity.EzyArray;
import com.tvd12.ezyfox.entity.EzyData;
import com.tvd12.ezyfox.function.EzyHandler;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfoxserver.context.EzyZoneChildContext;
import com.tvd12.ezyfoxserver.entity.EzySessionAware;
import com.tvd12.ezyfoxserver.entity.EzyUserAware;
import com.tvd12.ezyfoxserver.event.EzyUserRequestEvent;
import com.tvd12.ezyfoxserver.support.controller.EzyAbstractUserRequestController;
import com.tvd12.ezyfoxserver.support.manager.EzyFeatureCommandManager;
import com.tvd12.ezyfoxserver.support.manager.EzyRequestCommandManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class EzyUserRequestPrototypeController<C extends EzyZoneChildContext, E extends EzyUserRequestEvent>
extends EzyAbstractUserRequestController {
    protected final EzyBeanContext beanContext;
    protected final EzyUnmarshaller unmarshaller;
    protected final Map<String, EzyPrototypeSupplier> handlers;

    protected EzyUserRequestPrototypeController(Builder<?> builder) {
        this.beanContext = builder.beanContext;
        this.unmarshaller = builder.unmarshaller;
        this.handlers = new HashMap<String, EzyPrototypeSupplier>(((Builder)builder).extractHandlers());
    }

    public void handle(C context, E event) {
        EzyData params;
        EzyArray data = event.getData();
        String cmd = (String)data.get(0, String.class);
        EzyPrototypeSupplier supplier = this.handlers.get(cmd);
        if (supplier == null) {
            this.logger.warn("has no handler with command: {} from session: {}", (Object)cmd, (Object)event.getSession().getName());
            return;
        }
        EzyHandler handler = (EzyHandler)supplier.supply(this.beanContext);
        if (handler instanceof EzyUserAware) {
            ((EzyUserAware)handler).setUser(event.getUser());
        }
        if (handler instanceof EzySessionAware) {
            ((EzySessionAware)handler).setSession(event.getSession());
        }
        if (handler instanceof EzyDataBinding && (params = (EzyData)data.get(1, EzyData.class, null)) != null) {
            this.unmarshaller.unwrap((Object)params, (Object)handler);
        }
        try {
            this.preHandle(context, event, cmd, handler);
            handler.handle();
            this.postHandle(context, event, cmd, handler);
        }
        catch (EzyBadRequestException e) {
            if (e.isSendToClient()) {
                EzyData errorData = this.newErrorData(e);
                this.responseError(context, event, errorData);
            }
            this.logger.debug("request cmd: {} by session: {} with data: {} error", new Object[]{cmd, event.getSession().getName(), data, e});
            this.postHandle(context, event, cmd, handler, (Exception)((Object)e));
        }
        catch (Exception e) {
            this.postHandle(context, event, cmd, handler, e);
            throw e;
        }
    }

    protected abstract void preHandle(C var1, E var2, String var3, EzyHandler var4);

    protected void postHandle(C context, E event, String cmd, EzyHandler handler) {
    }

    protected void postHandle(C context, E event, String cmd, EzyHandler handler, Exception e) {
    }

    protected abstract void responseError(C var1, E var2, EzyData var3);

    @Override
    public Set<String> getCommands() {
        return new HashSet<String>(this.handlers.keySet());
    }

    public static abstract class Builder<B extends Builder>
    extends EzyLoggable
    implements EzyBuilder<EzyUserRequestPrototypeController> {
        protected EzyBeanContext beanContext;
        protected EzyPrototypeFactory prototypeFactory;
        protected EzyUnmarshaller unmarshaller;

        public B beanContext(EzyBeanContext beanContext) {
            this.beanContext = beanContext;
            this.prototypeFactory = beanContext.getPrototypeFactory();
            this.unmarshaller = (EzyUnmarshaller)beanContext.getSingleton("unmarshaller", EzyUnmarshaller.class);
            return (B)((Object)this);
        }

        private Map<String, EzyPrototypeSupplier> extractHandlers() {
            Map<String, EzyPrototypeSupplier> handlers = this.getHandlers();
            this.extractRequestCommands(handlers);
            return handlers;
        }

        private Map<String, EzyPrototypeSupplier> getHandlers() {
            List suppliers = this.prototypeFactory.getSuppliers(new Class[]{EzyRequestListener.class});
            HashMap<String, EzyPrototypeSupplier> handlers = new HashMap<String, EzyPrototypeSupplier>();
            for (EzyPrototypeSupplier supplier : suppliers) {
                Class handleType = supplier.getObjectType();
                EzyRequestListener annotation = handleType.getAnnotation(EzyRequestListener.class);
                String command = EzyRequestListenerAnnotations.getCommand((EzyRequestListener)annotation);
                handlers.put(command, supplier);
                this.logger.debug("add command {} and request handler supplier {}", (Object)command, (Object)supplier);
            }
            this.extractRequestCommands(handlers);
            return handlers;
        }

        private void extractRequestCommands(Map<String, EzyPrototypeSupplier> handlers) {
            EzyFeatureCommandManager featureCommandManager = (EzyFeatureCommandManager)this.beanContext.getSingleton(EzyFeatureCommandManager.class);
            EzyRequestCommandManager requestCommandManager = (EzyRequestCommandManager)this.beanContext.getSingleton(EzyRequestCommandManager.class);
            for (String command : handlers.keySet()) {
                EzyFeature featureAnno;
                EzyPrototypeSupplier handler = handlers.get(command);
                Class handleType = handler.getObjectType();
                requestCommandManager.addCommand(command);
                if (handleType.isAnnotationPresent(EzyManagement.class)) {
                    requestCommandManager.addManagementCommand(command);
                }
                if (handleType.isAnnotationPresent(EzyPayment.class)) {
                    requestCommandManager.addPaymentCommand(command);
                }
                if ((featureAnno = handleType.getAnnotation(EzyFeature.class)) == null || !EzyStrings.isNotBlank((String)featureAnno.value())) continue;
                featureCommandManager.addFeatureCommand(featureAnno.value(), command);
            }
        }
    }
}

