/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.server.core.servlet;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.reflect.EzyClassTree;
import com.tvd12.ezyfox.security.EzyBase64;
import com.tvd12.ezyhttp.core.codec.BodySerializer;
import com.tvd12.ezyhttp.core.codec.DataConverters;
import com.tvd12.ezyhttp.core.constant.HttpMethod;
import com.tvd12.ezyhttp.core.data.MultiValueMap;
import com.tvd12.ezyhttp.core.exception.DeserializeValueException;
import com.tvd12.ezyhttp.core.exception.HttpRequestException;
import com.tvd12.ezyhttp.core.response.ResponseEntity;
import com.tvd12.ezyhttp.server.core.handler.RequestHandler;
import com.tvd12.ezyhttp.server.core.handler.RequestResponseWatcher;
import com.tvd12.ezyhttp.server.core.handler.UncaughtExceptionHandler;
import com.tvd12.ezyhttp.server.core.handler.UnhandledErrorHandler;
import com.tvd12.ezyhttp.server.core.interceptor.RequestInterceptor;
import com.tvd12.ezyhttp.server.core.manager.ComponentManager;
import com.tvd12.ezyhttp.server.core.manager.ExceptionHandlerManager;
import com.tvd12.ezyhttp.server.core.manager.InterceptorManager;
import com.tvd12.ezyhttp.server.core.manager.RequestHandlerManager;
import com.tvd12.ezyhttp.server.core.manager.RequestURIManager;
import com.tvd12.ezyhttp.server.core.request.RequestArguments;
import com.tvd12.ezyhttp.server.core.request.SimpleRequestArguments;
import com.tvd12.ezyhttp.server.core.view.Redirect;
import com.tvd12.ezyhttp.server.core.view.View;
import com.tvd12.ezyhttp.server.core.view.ViewContext;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncListener;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingServlet
extends HttpServlet {
    private static final long serialVersionUID = -3874017929628817672L;
    private boolean debug;
    private int managementPort;
    private boolean exposeManagementURIs;
    private int asyncDefaultTimeout;
    protected ViewContext viewContext;
    protected ObjectMapper objectMapper;
    protected DataConverters dataConverters;
    protected ComponentManager componentManager;
    protected InterceptorManager interceptorManager;
    protected RequestURIManager requestURIManager;
    protected RequestHandlerManager requestHandlerManager;
    protected ExceptionHandlerManager exceptionHandlerManager;
    protected UnhandledErrorHandler unhandledErrorHandler;
    protected List<Class<?>> handledExceptionClasses;
    protected List<RequestResponseWatcher> requestResponseWatchers;
    protected Map<Class<?>, UncaughtExceptionHandler> uncaughtExceptionHandlers;
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public void init() throws ServletException {
        this.componentManager = ComponentManager.getInstance();
        this.debug = this.componentManager.isDebug();
        this.managementPort = this.componentManager.getManagementPort();
        this.exposeManagementURIs = this.componentManager.isExposeManagementURIs();
        this.asyncDefaultTimeout = this.componentManager.getAsyncDefaultTimeout();
        this.viewContext = this.componentManager.getViewContext();
        this.objectMapper = this.componentManager.getObjectMapper();
        this.dataConverters = this.componentManager.getDataConverters();
        this.interceptorManager = this.componentManager.getInterceptorManager();
        this.requestHandlerManager = this.componentManager.getRequestHandlerManager();
        this.requestURIManager = this.requestHandlerManager.getRequestURIManager();
        this.exceptionHandlerManager = this.componentManager.getExceptionHandlerManager();
        this.requestResponseWatchers = this.componentManager.getRequestResponseWatchers();
        this.addDefaultExceptionHandlers();
        this.unhandledErrorHandler = this.componentManager.getUnhandledErrorHandler();
        this.uncaughtExceptionHandlers = this.exceptionHandlerManager.getUncaughtExceptionHandlers();
        this.handledExceptionClasses = new EzyClassTree(this.uncaughtExceptionHandlers.keySet()).toList();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doHandleRequest(HttpMethod.GET, request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doHandleRequest(HttpMethod.POST, request, response);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doHandleRequest(HttpMethod.PUT, request, response);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doHandleRequest(HttpMethod.DELETE, request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHandleRequest(HttpMethod method, HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            this.watchRequest(method, request);
            this.handleRequest(method, request, response);
        }
        finally {
            if (!request.isAsyncStarted()) {
                this.watchResponse(method, request, response);
            }
        }
    }

    private void watchRequest(HttpMethod method, HttpServletRequest request) {
        for (RequestResponseWatcher watcher : this.requestResponseWatchers) {
            watcher.watchRequest(method, (ServletRequest)request);
        }
    }

    private void watchResponse(HttpMethod method, HttpServletRequest request, HttpServletResponse response) {
        for (RequestResponseWatcher watcher : this.requestResponseWatchers) {
            watcher.watchResponse(method, (ServletRequest)request, (ServletResponse)response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRequest(HttpMethod method, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String requestURI = request.getRequestURI();
        String matchedURI = this.requestHandlerManager.getMatchedURI(method, requestURI);
        if (matchedURI == null && (matchedURI = this.requestHandlerManager.getMatchedURI(method, requestURI = URLDecoder.decode(requestURI, "UTF-8"))) == null) {
            if (!this.handleError(method, request, response, 404)) {
                this.responseString(response, "uri " + requestURI + " not found");
            }
            return;
        }
        request.setAttribute("ezyAttributeMatchedURI", (Object)matchedURI);
        boolean isManagementURI = this.requestURIManager.isManagementURI(method, matchedURI);
        if (isManagementURI && !this.exposeManagementURIs && request.getServerPort() != this.managementPort) {
            this.handleError(method, request, response, 404);
            this.logger.warn("a normal client's not allowed call to: {}, please check your proxy configuration", (Object)requestURI);
            return;
        }
        RequestHandler requestHandler = this.requestHandlerManager.getHandler(method, matchedURI, isManagementURI);
        if (requestHandler == RequestHandler.EMPTY) {
            if (!this.handleError(method, request, response, 405)) {
                this.responseString(response, "method " + method + " not allowed");
            }
            return;
        }
        boolean acceptableRequest = false;
        boolean syncResponse = true;
        String uriTemplate = requestHandler.getRequestURI();
        RequestArguments arguments = this.newRequestArguments(method, uriTemplate, request, response);
        try {
            acceptableRequest = this.preHandleRequest(arguments, requestHandler);
            if (acceptableRequest) {
                if (requestHandler.isAsync()) {
                    syncResponse = false;
                    AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
                    if (this.asyncDefaultTimeout > 0) {
                        asyncContext.setTimeout((long)this.asyncDefaultTimeout);
                    }
                    asyncContext.addListener(this.newAsyncListener(arguments, requestHandler));
                    requestHandler.handle(arguments);
                } else {
                    Object responseData = requestHandler.handle(arguments);
                    String responseContentType = requestHandler.getResponseContentType();
                    if (responseContentType != null) {
                        response.setContentType(responseContentType);
                    }
                    if (responseData != null) {
                        this.handleResponseData(request, response, responseData);
                    } else {
                        response.setStatus(200);
                    }
                }
            } else {
                this.handleError(method, request, response, 406);
            }
        }
        catch (Exception e) {
            this.handleException(method, arguments, e);
        }
        finally {
            if (syncResponse) {
                if (acceptableRequest) {
                    this.postHandleRequest(arguments, requestHandler);
                }
                arguments.release();
            }
        }
    }

    protected AsyncListener newAsyncListener(RequestArguments arguments, RequestHandler requestHandler) {
        return event -> {
            try {
                try {
                    this.postHandleRequest(arguments, requestHandler);
                }
                finally {
                    this.watchResponse(arguments.getMethod(), arguments.getRequest(), arguments.getResponse());
                }
            }
            catch (Exception e) {
                this.logger.warn("AsyncCallback.onComplete on uri: {} error", (Object)arguments.getRequest().getRequestURI(), (Object)e);
            }
            finally {
                arguments.release();
            }
        };
    }

    protected boolean handleError(HttpMethod method, HttpServletRequest request, HttpServletResponse response, int errorStatusCode) {
        return this.handleError(method, request, response, errorStatusCode, null);
    }

    protected boolean handleError(HttpMethod method, HttpServletRequest request, HttpServletResponse response, int errorStatusCode, Exception exception) {
        if (exception != null) {
            this.logger.warn("handle request uri: {} error", (Object)request.getRequestURI(), (Object)exception);
        }
        if (this.unhandledErrorHandler != null) {
            Object data = this.unhandledErrorHandler.handleError(method, request, response, errorStatusCode, exception);
            if (data == null) {
                response.setStatus(errorStatusCode);
                return false;
            }
            try {
                this.handleResponseData(request, response, data);
            }
            catch (Exception e) {
                response.setStatus(500);
                this.logger.warn("handle error: {} with uri: {} failed", new Object[]{errorStatusCode, request.getRequestURI(), e});
            }
            return true;
        }
        response.setStatus(errorStatusCode);
        return false;
    }

    protected void handleException(HttpMethod method, RequestArguments arguments, Exception e) {
        UncaughtExceptionHandler handler = this.getUncaughtExceptionHandler(e.getClass());
        HttpServletRequest request = arguments.getRequest();
        HttpServletResponse response = arguments.getResponse();
        Exception exception = e;
        if (handler != null) {
            try {
                Object result = handler.handleException(arguments, e);
                if (result != null) {
                    String responseContentType = handler.getResponseContentType();
                    if (responseContentType != null) {
                        response.setContentType(responseContentType);
                    }
                    this.handleResponseData(request, response, result);
                } else {
                    this.handleError(method, request, response, 400);
                }
                exception = null;
            }
            catch (Exception ex) {
                exception = ex;
            }
        }
        if (exception != null) {
            this.handleError(method, request, response, 500, exception);
        }
    }

    protected UncaughtExceptionHandler getUncaughtExceptionHandler(Class<?> exceptionClass) {
        for (Class<?> exc : this.handledExceptionClasses) {
            if (!exc.isAssignableFrom(exceptionClass)) continue;
            return this.uncaughtExceptionHandlers.get(exc);
        }
        return null;
    }

    protected boolean preHandleRequest(RequestArguments arguments, RequestHandler requestHandler) throws Exception {
        Method handler = requestHandler.getHandlerMethod();
        for (RequestInterceptor interceptor : this.interceptorManager.getRequestInterceptors()) {
            boolean passed = interceptor.preHandle(arguments, handler);
            if (passed) continue;
            return false;
        }
        return true;
    }

    protected void postHandleRequest(RequestArguments arguments, RequestHandler requestHandler) {
        Method handler = requestHandler.getHandlerMethod();
        for (RequestInterceptor interceptor : this.interceptorManager.getRequestInterceptors()) {
            interceptor.postHandle(arguments, handler);
        }
    }

    protected void handleResponseData(HttpServletRequest request, HttpServletResponse response, Object data) throws Exception {
        Object body = data;
        if (data instanceof ResponseEntity) {
            ResponseEntity entity = (ResponseEntity)body;
            body = entity.getBody();
            response.setStatus(entity.getStatus());
            MultiValueMap headers = entity.getHeaders();
            if (headers != null) {
                Map map = headers.toMap();
                for (Map.Entry entry : map.entrySet()) {
                    response.addHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
        } else {
            if (data instanceof Redirect) {
                Redirect redirect = (Redirect)data;
                for (Cookie cookie : redirect.getCookies()) {
                    response.addCookie(cookie);
                }
                for (Map.Entry entry : redirect.getHeaders().entrySet()) {
                    response.addHeader((String)entry.getKey(), (String)entry.getValue());
                }
                Map<String, Object> attributes = redirect.getAttributes();
                if (attributes != null) {
                    String string = this.objectMapper.writeValueAsString(attributes);
                    Cookie attributesCookie = new Cookie("ezyRedirectAttributes", EzyBase64.encodeUtf((String)string));
                    attributesCookie.setPath("/");
                    attributesCookie.setMaxAge(60);
                    response.addCookie(attributesCookie);
                }
                response.sendRedirect(redirect.getUri() + redirect.getQueryString());
                return;
            }
            if (data instanceof View) {
                if (this.viewContext == null) {
                    throw new IllegalStateException("viewContext is null, you must add ezyhttp-server-thymeleaf to your dependencies or create viewContext by yourself");
                }
                View view = (View)data;
                for (Cookie cookie : view.getCookies()) {
                    response.addCookie(cookie);
                }
                for (Map.Entry entry : view.getHeaders().entrySet()) {
                    response.addHeader((String)entry.getKey(), (String)entry.getValue());
                }
                response.setContentType(view.getContentType());
                this.viewContext.render(this.getServletContext(), request, response, view);
                return;
            }
            response.setStatus(200);
        }
        if (body != null) {
            this.responseBody(response, body);
        }
    }

    protected void responseBody(HttpServletResponse response, Object data) throws IOException {
        String contentType = response.getContentType();
        BodySerializer bodySerializer = this.dataConverters.getBodySerializer(contentType);
        byte[] bytes = bodySerializer.serialize(data);
        this.responseBytes(response, bytes);
    }

    protected void responseString(HttpServletResponse response, String str) throws IOException {
        byte[] bytes = EzyStrings.getUtfBytes((String)str);
        this.responseBytes(response, bytes);
    }

    protected void responseBytes(HttpServletResponse response, byte[] bytes) throws IOException {
        response.setContentLength(bytes.length);
        ServletOutputStream outputStream = response.getOutputStream();
        outputStream.write(bytes);
    }

    protected RequestArguments newRequestArguments(HttpMethod method, String uriTemplate, HttpServletRequest request, HttpServletResponse response) {
        SimpleRequestArguments arguments = new SimpleRequestArguments();
        arguments.setDebug(this.debug);
        arguments.setMethod(method);
        arguments.setRequest(request);
        arguments.setResponse(response);
        arguments.setUriTemplate(uriTemplate);
        arguments.setCookies(request.getCookies());
        arguments.setObjectMapper(this.objectMapper);
        arguments.setRedirectionAttributesFromCookie();
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            String[] paramValues = request.getParameterValues(paramName);
            arguments.setParameter(paramName, paramValues);
        }
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            String headerValue = request.getHeader(headerName);
            arguments.setHeader(headerName, headerValue);
        }
        return arguments;
    }

    protected void addDefaultExceptionHandlers() {
        this.exceptionHandlerManager.addUncaughtExceptionHandler(DeserializeValueException.class, (args, e) -> {
            DeserializeValueException deException = (DeserializeValueException)e;
            HashMap<String, String> errorData = new HashMap<String, String>();
            errorData.put(deException.getValueName(), "invalid");
            errorData.put("exception", e.getClass().getName());
            return ResponseEntity.create((int)400, errorData);
        });
        this.exceptionHandlerManager.addUncaughtExceptionHandler(HttpRequestException.class, (args, e) -> {
            HttpRequestException requestException = (HttpRequestException)e;
            int errorStatus = requestException.getCode();
            Map errorData = requestException.getData();
            if (errorData == null) {
                errorData = Collections.emptyMap();
            }
            return ResponseEntity.create((int)errorStatus, errorData);
        });
    }
}

