/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.service;

import com.tvd12.ezyfox.io.EzyLists;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.util.EzyEntry;
import com.tvd12.reflections.util.Predicates;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.youngmonkeys.ezyplatform.model.AdminMetaModel;
import org.youngmonkeys.ezyplatform.util.Strings;

public interface AdminMetaService {
    public void saveAdminMeta(long var1, String var3, String var4);

    default public void saveAdminMeta(long adminId, String metaKey, Object metaValue) {
        this.saveAdminMeta(adminId, metaKey, Strings.from(metaValue));
    }

    public void saveAdminMeta(long var1, String var3, List<String> var4);

    default public void saveAdminMeta(long adminId, String metaKey, Collection<Object> metaValues) {
        this.saveAdminMeta(adminId, metaKey, EzyLists.newArrayList(metaValues, Strings::from));
    }

    default public void saveAdminMetaIfAbsent(long adminId, String metaKey, Object metaValue) {
        this.saveAdminMetaIfAbsent(adminId, metaKey, Strings.from(metaValue));
    }

    public void saveAdminMetaIfAbsent(long var1, String var3, String var4);

    default public void saveAdminMetaIfAbsent(long adminId, String metaKey, List<String> metaValues) {
        metaValues.parallelStream().filter(Objects::nonNull).forEach(metaValue -> this.saveAdminMetaIfAbsent(adminId, metaKey, (String)metaValue));
    }

    default public void saveAdminMetaIfAbsent(long adminId, String metaKey, Collection<Object> metaValues) {
        metaValues.parallelStream().filter(Objects::nonNull).forEach(metaValue -> this.saveAdminMetaIfAbsent(adminId, metaKey, metaValue));
    }

    default public void saveAdminMetaUniqueKey(long adminId, String metaKey, Object metaValue) {
        this.saveAdminMetaUniqueKey(adminId, metaKey, Strings.from(metaValue));
    }

    default public void saveAdminMetaUniqueKey(long adminId, String metaKey, String metaValue) {
        this.saveAdminMetaUniqueKey(adminId, metaKey, metaValue, null);
    }

    public void saveAdminMetaUniqueKey(long var1, String var3, String var4, String var5);

    default public void saveAdminMetaUniqueKeys(long adminId, Map<String, Object> valueMap) {
        valueMap.entrySet().parallelStream().filter(e -> e.getValue() != null).forEach(e -> this.saveAdminMetaUniqueKey(adminId, (String)e.getKey(), e.getValue()));
    }

    default public void saveAdminMetaTextValueUniqueKeys(long adminId, Map<String, Object> valueMap) {
        valueMap.entrySet().parallelStream().filter(e -> e.getValue() != null).forEach(e -> this.saveAdminMetaUniqueKey(adminId, (String)e.getKey(), "", Strings.from(e.getValue())));
    }

    public BigDecimal increaseAdminMetaValue(long var1, String var3, BigDecimal var4);

    default public BigInteger increaseAdminMetaValue(long adminId, String metaKey, BigInteger value) {
        return this.increaseAdminMetaValue(adminId, metaKey, new BigDecimal(value)).toBigInteger();
    }

    public void deleteAdminMetaById(long var1);

    public void deleteAdminMetaByAdminId(long var1);

    public void deleteAdminMetaByAdminIds(Collection<Long> var1);

    public boolean containsAdminMeta(long var1, String var3, String var4);

    public long getAdminIdByMeta(String var1, String var2);

    default public long getAdminIdByMeta(String metaKey, Object metaValue) {
        return this.getAdminIdByMeta(metaKey, Strings.from(metaValue));
    }

    public String getMetaValueByAdminIdAndMetaKey(long var1, String var3);

    public String getLatestMetaValueByAdminIdAndMetaKey(long var1, String var3);

    default public String getMetaValueByAdminIdAndMetaKeyOrDefault(long adminId, String metaKey, String defaultValue) {
        String value = this.getMetaValueByAdminIdAndMetaKey(adminId, metaKey);
        return value != null ? value : defaultValue;
    }

    public String getMetaTextValueByAdminIdAndMetaKey(long var1, String var3);

    public String getLatestMetaTextValueByAdminIdAndMetaKey(long var1, String var3);

    default public String getMetaTextValueByAdminIdAndMetaKeyOrDefault(long adminId, String metaKey, String defaultValue) {
        String value = this.getMetaTextValueByAdminIdAndMetaKey(adminId, metaKey);
        return value != null ? value : defaultValue;
    }

    default public BigDecimal getMetaDecimalValueByAdminIdAndMetaKey(long adminId, String metaKey) {
        String value = this.getMetaValueByAdminIdAndMetaKey(adminId, metaKey);
        return value != null ? new BigDecimal(value) : BigDecimal.ZERO;
    }

    default public BigInteger getMetaIntegerValueByAdminIdAndMetaKey(long adminId, String metaKey) {
        String value = this.getMetaValueByAdminIdAndMetaKey(adminId, metaKey);
        return value != null ? new BigInteger(value) : BigInteger.ZERO;
    }

    public List<String> getMetaValuesByAdminIdAndMetaKey(long var1, String var3, int var4);

    default public <T> List<T> getMetaValuesByAdminIdAndMetaKey(long adminId, String metaKey, int limit, Function<String, T> valueConverter) {
        return EzyLists.newArrayList(this.getMetaValuesByAdminIdAndMetaKey(adminId, metaKey, limit), valueConverter);
    }

    public Map<String, String> getAdminMetaValues(long var1);

    public Map<String, String> getAdminMetaTextValues(long var1);

    public Map<Long, Map<String, AdminMetaModel>> getAdminMetaValueMapsByAdminIds(Collection<Long> var1);

    default public <T> Map<Long, Map<String, T>> getAdminMetaValueMapsByAdminIds(Collection<Long> adminIds, Function<AdminMetaModel, T> converter) {
        return this.getAdminMetaValueMapsByAdminIds(adminIds).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Map)e.getValue()).entrySet().stream().map(it -> EzyEntry.of(it.getKey(), converter.apply((AdminMetaModel)it.getValue()))).filter(it -> it.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))));
    }

    public Map<String, Long> getAdminIdMapByMetaValues(String var1, Collection<String> var2);

    public Map<Long, String> getAdminMetaValueMapByAdminIds(Collection<Long> var1, String var2);

    default public <T> Map<Long, T> getAdminMetaValueMapByAdminIds(Collection<Long> adminIds, String metaKey, Function<String, T> valueConverter) {
        return this.getAdminMetaValueMapByAdminIds(adminIds, metaKey, Predicates.alwaysTrue(), valueConverter);
    }

    default public <T> Map<Long, T> getAdminMetaValueMapByAdminIds(Collection<Long> adminIds, String metaKey, Predicate<String> valueFilter, Function<String, T> valueConverter) {
        return this.getAdminMetaValueMapByAdminIds(adminIds, metaKey).entrySet().stream().filter(e -> e.getValue() != null).filter(e -> valueFilter.test((String)e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, e -> valueConverter.apply((String)e.getValue())));
    }

    public Map<String, String> getAdminMetaValueMapByAdminIdAndMetaKeys(long var1, Collection<String> var3);

    default public Map<String, String> getLatestMetaValueMapByAdminIdAndMetaKeys(long adminId, Collection<String> metaKeys) {
        return metaKeys.parallelStream().map(it -> EzyEntry.of((Object)it, (Object)this.getLatestMetaValueByAdminIdAndMetaKey(adminId, (String)it))).filter(it -> it.getValue() != null).collect(Collectors.toMap(EzyEntry::getKey, EzyEntry::getValue));
    }

    default public Map<String, String> getLatestMetaTextValueMapByAdminIdAndMetaKeys(long adminId, Collection<String> metaKeys) {
        return metaKeys.parallelStream().map(it -> EzyEntry.of((Object)it, (Object)this.getLatestMetaTextValueByAdminIdAndMetaKey(adminId, (String)it))).filter(it -> it.getValue() != null).collect(Collectors.toMap(EzyEntry::getKey, EzyEntry::getValue));
    }

    public Map<Long, String> getAdminMetaTextValueMapByAdminIds(Collection<Long> var1, String var2);

    default public Map<Long, BigDecimal> getAdminMetaBigDecimalValueMapByAdminIds(Collection<Long> adminIds, String metaKey) {
        return this.getAdminMetaValueMapByAdminIds(adminIds, metaKey, EzyStrings::isNotBlank, BigDecimal::new);
    }

    default public Map<Long, BigInteger> getAdminMetaBigIntegerValueMapByAdminIds(Collection<Long> adminIds, String metaKey) {
        return this.getAdminMetaValueMapByAdminIds(adminIds, metaKey, EzyStrings::isNotBlank, BigInteger::new);
    }

    public List<AdminMetaModel> getMetaListByAdminIdAndMetaKeys(long var1, Collection<String> var3);
}

