/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.youngmonkeys.ezyplatform.util.Strings;

public final class JavascriptExecutors {
    private JavascriptExecutors() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object execute(String script, Map<String, Object> parameters) {
        Context context = Context.enter();
        try {
            ScriptableObject scope = context.initStandardObjects();
            for (Map.Entry<String, Object> e : parameters.entrySet()) {
                scope.put(e.getKey(), (Scriptable)scope, e.getValue());
            }
            Object object = context.evaluateString((Scriptable)scope, script, null, 0, null);
            return object;
        }
        finally {
            Context.exit();
        }
    }

    public static BigDecimal execute(String script, Map<String, Object> parameters, int bigDecimalScale, RoundingMode roundingMode) {
        Object result = JavascriptExecutors.execute(script, parameters);
        if (result == null) {
            return null;
        }
        if (result instanceof Undefined) {
            return null;
        }
        String resultStr = result.toString();
        BigDecimal resultBigDecimal = Strings.toBigDecimalOrNull(resultStr);
        if (resultBigDecimal == null) {
            return null;
        }
        return resultBigDecimal.setScale(bigDecimalScale, roundingMode);
    }
}

