/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.logback;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.youngmonkeys.ezyplatform.logback.LogbackAppender;

public final class LogbackAppenderManager {
    private final Map<Class<?>, LogbackAppender> appenderByType = new ConcurrentHashMap();
    public static final LogbackAppenderManager INSTANCE = new LogbackAppenderManager();

    public static LogbackAppenderManager getInstance() {
        return INSTANCE;
    }

    private LogbackAppenderManager() {
    }

    public void addAppender(LogbackAppender appender) {
        this.appenderByType.putIfAbsent(((Object)((Object)appender)).getClass(), appender);
    }

    public void forEach(Consumer<LogbackAppender> consumer) {
        this.appenderByType.values().forEach(consumer);
    }
}

