/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.service;

import com.tvd12.ezyfox.io.EzyLists;
import com.tvd12.ezyfox.io.EzyMaps;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.security.EzySHA256;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.youngmonkeys.ezyplatform.data.ImageSize;
import org.youngmonkeys.ezyplatform.entity.MediaType;
import org.youngmonkeys.ezyplatform.entity.UploadFrom;
import org.youngmonkeys.ezyplatform.model.AddMediaModel;
import org.youngmonkeys.ezyplatform.model.MediaModel;
import org.youngmonkeys.ezyplatform.model.MediaNameModel;
import org.youngmonkeys.ezyplatform.model.SimpleMediaModel;
import org.youngmonkeys.ezyplatform.model.UpdateMediaModel;

public interface MediaService {
    public MediaModel addMedia(AddMediaModel var1);

    public MediaModel addMedia(AddMediaModel var1, UploadFrom var2);

    public void updateMedia(UpdateMediaModel var1);

    public void updateMedia(long var1, UpdateMediaModel var3);

    public void updateMedia(boolean var1, long var2, UpdateMediaModel var4);

    public void updateMediaOwner(long var1, long var3);

    default public void saveMediaDurationInSeconds(long mediaId, BigDecimal duration) {
        this.saveMediaDurationInMinutes(mediaId, duration != null ? duration.divide(BigDecimal.valueOf(60L), 2, RoundingMode.HALF_UP) : BigDecimal.ZERO);
    }

    public void saveMediaDurationInMinutes(long var1, BigDecimal var3);

    public MediaModel removeMedia(long var1);

    public MediaModel removeMedia(long var1, String var3);

    public MediaModel removeMedia(boolean var1, long var2, long var4, String var6);

    public MediaModel getMediaById(long var1);

    default public MediaNameModel getMediaNameById(long mediaId) {
        return MediaNameModel.fromMediaModel(this.getMediaById(mediaId));
    }

    default public SimpleMediaModel getSimpleMediaModelById(long mediaId) {
        return SimpleMediaModel.fromMediaModel(this.getMediaById(mediaId));
    }

    public MediaModel getMediaByName(String var1);

    public boolean containsMedia(long var1);

    default public List<MediaModel> getMediaListByIds(Collection<Long> mediaIds) {
        Map<Long, MediaModel> mediaMap = this.getMediaMapByIds(mediaIds);
        return mediaIds.stream().map(mediaMap::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    default public List<MediaNameModel> getMediaNameListByIds(Collection<Long> mediaIds) {
        return EzyLists.newArrayList(this.getMediaListByIds(mediaIds), MediaNameModel::fromMediaModel);
    }

    public Map<Long, MediaModel> getMediaMapByIds(Collection<Long> var1);

    default public Map<Long, MediaNameModel> getMediaNameMapByIds(Collection<Long> mediaIds) {
        return EzyMaps.newHashMapNewValues(this.getMediaMapByIds(mediaIds), MediaNameModel::fromMediaModel);
    }

    public long getMediaFileLength(MediaType var1, String var2);

    public long getMediaFileLengthOrNegative(MediaType var1, String var2);

    public long getMediaFileLengthOrZero(File var1);

    public ImageSize getMediaImageSize(long var1) throws IOException;

    public ImageSize getMediaImageSize(String var1, MediaType var2) throws IOException;

    default public ImageSize getMediaImageSize(String imageName) throws IOException {
        return this.getMediaImageSize(imageName, MediaType.IMAGE);
    }

    public ImageSize getMediaImageSizeOrNull(String var1, MediaType var2);

    public ImageSize getMediaImageSizeOrDefault(File var1);

    default public String generateMediaFileName() {
        return this.generateMediaFileName("", null);
    }

    default public String generateMediaFileName(String submittedFileName, String extension) {
        String uniqueFileName = EzySHA256.cryptUtfToLowercase((String)(submittedFileName + System.currentTimeMillis() + UUID.randomUUID()));
        return EzyStrings.isBlank((String)extension) ? uniqueFileName : uniqueFileName + "." + extension;
    }

    default public BigDecimal getMediaDurationInSeconds(long mediaId) {
        BigDecimal minutes = this.getMediaDurationInMinutes(mediaId);
        return minutes != null ? minutes.multiply(BigDecimal.valueOf(60L)) : BigDecimal.ZERO;
    }

    default public Map<Long, BigDecimal> getMediaDurationInSecondsByIds(Collection<Long> mediaIds) {
        return this.getMediaDurationInMinutesByIds(mediaIds).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((BigDecimal)e.getValue()).multiply(BigDecimal.valueOf(60L))));
    }

    public BigDecimal getMediaDurationInMinutes(long var1);

    public Map<Long, BigDecimal> getMediaDurationInMinutesByIds(Collection<Long> var1);
}

