/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.security.EzyAesCrypt;
import com.tvd12.ezyfox.security.EzyBase64;
import java.util.Collection;
import org.youngmonkeys.ezyplatform.concurrent.Scheduler;
import org.youngmonkeys.ezyplatform.converter.DefaultModelToEntityConverter;
import org.youngmonkeys.ezyplatform.entity.DataType;
import org.youngmonkeys.ezyplatform.entity.Setting;
import org.youngmonkeys.ezyplatform.manager.FileSystemManager;
import org.youngmonkeys.ezyplatform.repo.SettingRepository;
import org.youngmonkeys.ezyplatform.service.DefaultSettingService;

public abstract class MutableSettingService
extends DefaultSettingService {
    private final SettingRepository settingRepository;
    private final DefaultModelToEntityConverter modelToEntityConverter;

    public MutableSettingService(Scheduler scheduler, ObjectMapper objectMapper, FileSystemManager fileSystemManager, SettingRepository settingRepository, DefaultModelToEntityConverter modelToEntityConverter) {
        super(scheduler, objectMapper, fileSystemManager, settingRepository);
        this.settingRepository = settingRepository;
        this.modelToEntityConverter = modelToEntityConverter;
    }

    public void setLastUpdateTime(String settingName) {
        this.setLastUpdateTime(settingName, System.currentTimeMillis());
    }

    public void setLastUpdateTime(String settingName, long time) {
        this.setLongValue(settingName + "_last_updated_time", time);
    }

    public void setBooleanValue(String settingName, Boolean value) {
        this.saveSetting(settingName, DataType.BOOLEAN, value);
    }

    public void setIntValue(String settingName, Integer value) {
        this.saveSetting(settingName, DataType.INTEGER, value);
    }

    public void setLongValue(String settingName, Long value) {
        this.saveSetting(settingName, DataType.LONG, value);
    }

    public void setTextValue(String settingName, String value) {
        this.saveSetting(settingName, DataType.STRING, value);
    }

    public void setUrlValue(String settingName, String url) {
        this.saveSetting(settingName, DataType.URL, url);
    }

    public void setArrayValue(String settingName, Collection<?> array) {
        this.saveSetting(settingName, DataType.ARRAY, EzyStrings.join(array, (String)","));
    }

    public void setObjectValue(String settingName, Object value) {
        this.saveSetting(settingName, DataType.JSON, value);
    }

    public void setPasswordValue(String settingName, String value) {
        this.saveSetting(settingName, DataType.PASSWORD, this.encryptValue(value));
    }

    @Override
    public void saveSetting(String name, DataType dataType, Object value) {
        Setting entity = (Setting)this.settingRepository.findByField("name", name);
        if (entity == null) {
            entity = this.modelToEntityConverter.toSettingEntity(name, dataType, value);
        } else {
            this.modelToEntityConverter.mergeToSettingEntity(name, dataType, value, entity);
        }
        this.settingRepository.save(entity);
    }

    public void removeSetting(long settingId) {
        this.settingRepository.delete(settingId);
    }

    public void removeSetting(String settingName) {
        this.settingRepository.deleteByName(settingName);
    }

    @Override
    public String encryptValue(String settingValue) {
        return this.encryptValue(settingValue, this.getEncryptionKey());
    }

    protected String encryptValue(String settingValue, String encryptionKey) {
        try {
            return EzyBase64.encode2utf((byte[])EzyAesCrypt.getDefault().encrypt(settingValue.getBytes(), encryptionKey.getBytes()));
        }
        catch (Exception e) {
            return settingValue;
        }
    }
}

