/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.time;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.io.EzyDates;
import java.time.Clock;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.util.LocalDateTimes;

@EzySingleton
public class ClockProxy {
    private final Clock clock;
    private final ZoneId zoneId;

    public LocalDate nowDate() {
        return this.nowDateTime().toLocalDate();
    }

    public LocalDateTime nowDateTime() {
        return EzyDates.millisToDateTime((long)this.clock.millis(), (ZoneId)this.zoneId);
    }

    public long toTimestamp(LocalDate date) {
        return LocalDateTimes.toTimestamp(date, this.zoneId);
    }

    public long toTimestamp(LocalDateTime dateTime) {
        return LocalDateTimes.toTimestamp(dateTime, this.zoneId);
    }

    public LocalDate toLocalDate(long millis) {
        return this.toLocalDateTime(millis).toLocalDate();
    }

    public LocalDate toLocalDateOrNull(long millis) {
        return millis <= 0L ? null : this.toLocalDateTime(millis).toLocalDate();
    }

    public LocalDateTime toLocalDateTime(long millis) {
        return EzyDates.millisToDateTime((long)millis, (ZoneId)this.zoneId);
    }

    public LocalDateTime toLocalDateTimeOrNull(long millis) {
        return millis <= 0L ? null : EzyDates.millisToDateTime((long)millis, (ZoneId)this.zoneId);
    }

    public LocalDateTime nowDateTimeIfNull(LocalDateTime value) {
        return value != null ? value : this.nowDateTime();
    }

    @Generated
    public ClockProxy(Clock clock, ZoneId zoneId) {
        this.clock = clock;
        this.zoneId = zoneId;
    }
}

