/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.builder;

import com.tvd12.ezyfoxserver.EzyBootstrap;
import com.tvd12.ezyfoxserver.EzyServer;
import com.tvd12.ezyfoxserver.EzyServerBootstrap;
import com.tvd12.ezyfoxserver.builder.EzyServerBootstrapBuilder;
import com.tvd12.ezyfoxserver.builder.EzyServerContextBuilder;
import com.tvd12.ezyfoxserver.builder.EzySimpleServerContextBuilder;
import com.tvd12.ezyfoxserver.config.EzyConfig;
import com.tvd12.ezyfoxserver.context.EzyServerContext;
import com.tvd12.ezyfoxserver.setting.EzySettings;
import com.tvd12.ezyfoxserver.setting.EzySocketSetting;
import com.tvd12.ezyfoxserver.setting.EzySslConfigSetting;
import com.tvd12.ezyfoxserver.setting.EzyThreadPoolSizeSetting;
import com.tvd12.ezyfoxserver.setting.EzyWebSocketSetting;
import com.tvd12.ezyfoxserver.ssl.EzySslContextInitializer;
import javax.net.ssl.SSLContext;

public abstract class EzyAbstractServerBootstrapBuilder
implements EzyServerBootstrapBuilder {
    protected EzyServer server;
    protected EzyServerContext serverContext;

    @Override
    public EzyAbstractServerBootstrapBuilder server(EzyServer server) {
        this.server = server;
        this.serverContext = this.newServerContext(server);
        return this;
    }

    public final EzyServerBootstrap build() {
        this.preBuild();
        return this.buildServerBootstrap();
    }

    protected void preBuild() {
    }

    protected EzyServerBootstrap buildServerBootstrap() {
        EzyServerBootstrap answer = this.newServerBootstrap();
        answer.setContext(this.serverContext);
        answer.setLocalBootstrap(this.newLocalBoostrap());
        return answer;
    }

    protected EzyServerContext newServerContext(EzyServer server) {
        return (EzyServerContext)this.newServerContextBuilder().server(server).build();
    }

    protected SSLContext newSslContext(EzySslConfigSetting sslConfig) {
        EzySocketSetting socketSetting = this.getSocketSetting();
        EzyWebSocketSetting webSocketSetting = this.getWebsocketSetting();
        boolean activeSslForSocket = socketSetting.isCertificationSslActive();
        boolean activeSslForWebsocket = webSocketSetting.isSslActive();
        if (activeSslForSocket || activeSslForWebsocket) {
            return this.newSslContextInitializer(sslConfig).init();
        }
        return null;
    }

    protected EzySslContextInitializer newSslContextInitializer(EzySslConfigSetting sslConfig) {
        return this.newSslContextInitializerBuilder().sslConfig(sslConfig).homeFolderPath(this.getConfig().getEzyfoxHome()).build();
    }

    protected EzySslContextInitializer.Builder newSslContextInitializerBuilder() {
        return EzySslContextInitializer.builder();
    }

    protected EzyBootstrap newLocalBoostrap() {
        return EzyBootstrap.builder().context(this.serverContext).build();
    }

    protected EzyServerContextBuilder<?> newServerContextBuilder() {
        return new EzySimpleServerContextBuilder();
    }

    protected abstract EzyServerBootstrap newServerBootstrap();

    protected EzyConfig getConfig() {
        return this.server.getConfig();
    }

    protected EzySettings getSettings() {
        return this.server.getSettings();
    }

    protected EzySocketSetting getSocketSetting() {
        return this.getSettings().getSocket();
    }

    protected EzyWebSocketSetting getWebsocketSetting() {
        return this.getSettings().getWebsocket();
    }

    protected EzyThreadPoolSizeSetting getThreadPoolSizeSetting() {
        return this.getSettings().getThreadPoolSize();
    }
}

