/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.creator;

import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfoxserver.creator.EzySessionCreator;
import com.tvd12.ezyfoxserver.entity.EzySession;
import com.tvd12.ezyfoxserver.setting.EzySessionManagementSetting;
import com.tvd12.ezyfoxserver.socket.EzyChannel;
import com.tvd12.ezyfoxserver.wrapper.EzySessionManager;

public class EzySimpleSessionCreator
implements EzySessionCreator {
    protected final EzySessionManager sessionManager;
    protected final EzySessionManagementSetting sessionSetting;

    public EzySimpleSessionCreator(Builder builder) {
        this.sessionManager = builder.sessionManager;
        this.sessionSetting = builder.sessionSetting;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public <S extends EzySession> S create(EzyChannel channel) {
        EzySession session = this.newSession(channel);
        session.setActivated(true);
        session.setMaxIdleTime(this.sessionSetting.getSessionMaxIdleTime());
        session.setMaxWaitingTime(this.sessionSetting.getSessionMaxWaitingTime());
        return (S)session;
    }

    protected EzySession newSession(EzyChannel channel) {
        return this.sessionManager.provideSession(channel);
    }

    public static class Builder
    implements EzyBuilder<EzySessionCreator> {
        private EzySessionManager sessionManager;
        private EzySessionManagementSetting sessionSetting;

        public Builder sessionManager(EzySessionManager sessionManager) {
            this.sessionManager = sessionManager;
            return this;
        }

        public Builder sessionSetting(EzySessionManagementSetting sessionSetting) {
            this.sessionSetting = sessionSetting;
            return this;
        }

        public EzySessionCreator build() {
            return new EzySimpleSessionCreator(this);
        }
    }
}

