/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.factory;

import com.tvd12.ezyfoxserver.entity.EzyAbstractSession;
import com.tvd12.ezyfoxserver.entity.EzySession;
import com.tvd12.ezyfoxserver.factory.EzySessionFactory;
import com.tvd12.ezyfoxserver.setting.EzySessionManagementSetting;
import com.tvd12.ezyfoxserver.socket.EzyNonBlockingPacketQueue;
import com.tvd12.ezyfoxserver.socket.EzyNonBlockingRequestQueue;
import com.tvd12.ezyfoxserver.statistics.EzyRequestFrameSecond;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;

public abstract class EzyAbstractSessionFactory<S extends EzySession>
implements EzySessionFactory<S> {
    protected final AtomicInteger counter = new AtomicInteger(0);
    protected EzySessionManagementSetting.EzyMaxRequestPerSecond maxRequestPerSecond;

    public final S newProduct() {
        S session = this.newSession();
        this.initSession((EzyAbstractSession)session);
        return session;
    }

    protected void initSession(EzyAbstractSession session) {
        session.setId(this.counter.incrementAndGet());
        session.setCreationTime(System.currentTimeMillis());
        session.setPacketQueue(new EzyNonBlockingPacketQueue());
        session.setSystemRequestQueue(new EzyNonBlockingRequestQueue());
        session.setExtensionRequestQueue(new EzyNonBlockingRequestQueue());
        session.setRequestFrameInSecond(new EzyRequestFrameSecond(this.maxRequestPerSecond.getValue()));
    }

    protected abstract S newSession();

    @Generated
    public void setMaxRequestPerSecond(EzySessionManagementSetting.EzyMaxRequestPerSecond maxRequestPerSecond) {
        this.maxRequestPerSecond = maxRequestPerSecond;
    }
}

