/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.setting;

import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfoxserver.constant.EzyEventType;
import com.tvd12.ezyfoxserver.setting.EzySettings;
import com.tvd12.ezyfoxserver.setting.EzySimpleAdminSetting;
import com.tvd12.ezyfoxserver.setting.EzySimpleAdminsSetting;
import com.tvd12.ezyfoxserver.setting.EzySimpleEventControllerSetting;
import com.tvd12.ezyfoxserver.setting.EzySimpleEventControllersSetting;
import com.tvd12.ezyfoxserver.setting.EzySimpleHttpSetting;
import com.tvd12.ezyfoxserver.setting.EzySimpleLoggerSetting;
import com.tvd12.ezyfoxserver.setting.EzySimpleSessionManagementSetting;
import com.tvd12.ezyfoxserver.setting.EzySimpleSettings;
import com.tvd12.ezyfoxserver.setting.EzySimpleSocketSetting;
import com.tvd12.ezyfoxserver.setting.EzySimpleStreamingSetting;
import com.tvd12.ezyfoxserver.setting.EzySimpleThreadPoolSizeSetting;
import com.tvd12.ezyfoxserver.setting.EzySimpleUdpSetting;
import com.tvd12.ezyfoxserver.setting.EzySimpleWebSocketSetting;
import com.tvd12.ezyfoxserver.setting.EzySimpleZoneSetting;
import com.tvd12.ezyfoxserver.setting.EzySimpleZonesSetting;
import com.tvd12.ezyfoxserver.setting.EzyZoneSetting;

public class EzySettingsBuilder
implements EzyBuilder<EzySettings> {
    protected boolean debug;
    protected String nodeName = "ezyfox";
    protected int maxSessions = 999999;
    protected EzySimpleStreamingSetting streaming = new EzySimpleStreamingSetting();
    protected EzySimpleHttpSetting http = new EzySimpleHttpSetting();
    protected EzySimpleSocketSetting socket = new EzySimpleSocketSetting();
    protected EzySimpleUdpSetting udp = new EzySimpleUdpSetting();
    protected EzySimpleAdminsSetting admins = new EzySimpleAdminsSetting();
    protected EzySimpleLoggerSetting logger = new EzySimpleLoggerSetting();
    protected EzySimpleWebSocketSetting websocket = new EzySimpleWebSocketSetting();
    protected EzySimpleThreadPoolSizeSetting threadPoolSize = new EzySimpleThreadPoolSizeSetting();
    protected EzySimpleSessionManagementSetting sessionManagement = new EzySimpleSessionManagementSetting();
    protected EzySimpleEventControllersSetting eventControllers = new EzySimpleEventControllersSetting();
    protected EzySimpleZonesSetting zones = new EzySimpleZonesSetting();

    public EzySettingsBuilder debug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public EzySettingsBuilder nodeName(String nodeName) {
        this.nodeName = nodeName;
        return this;
    }

    public EzySettingsBuilder maxSessions(int maxSessions) {
        this.maxSessions = maxSessions;
        return this;
    }

    public EzySettingsBuilder streaming(EzySimpleStreamingSetting streaming) {
        this.streaming = streaming;
        return this;
    }

    public EzySettingsBuilder http(EzySimpleHttpSetting http) {
        this.http = http;
        return this;
    }

    public EzySettingsBuilder socket(EzySimpleSocketSetting socket) {
        this.socket = socket;
        return this;
    }

    public EzySettingsBuilder udp(EzySimpleUdpSetting udp) {
        this.udp = udp;
        return this;
    }

    public EzySettingsBuilder admin(EzySimpleAdminSetting admin) {
        this.admins.setItem(admin);
        return this;
    }

    public EzySettingsBuilder admins(EzySimpleAdminsSetting admins) {
        this.admins = admins;
        return this;
    }

    public EzySettingsBuilder logger(EzySimpleLoggerSetting logger) {
        this.logger = logger;
        return this;
    }

    public EzySettingsBuilder websocket(EzySimpleWebSocketSetting websocket) {
        this.websocket = websocket;
        return this;
    }

    public EzySettingsBuilder threadPoolSize(EzySimpleThreadPoolSizeSetting threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
        return this;
    }

    public EzySettingsBuilder sessionManagement(EzySimpleSessionManagementSetting sessionManagement) {
        this.sessionManagement = sessionManagement;
        return this;
    }

    public EzySettingsBuilder eventControllers(EzySimpleEventControllersSetting eventControllers) {
        this.eventControllers = eventControllers;
        return this;
    }

    public EzySettingsBuilder addEventController(String eventType, String controller) {
        EzySimpleEventControllerSetting eventController = new EzySimpleEventControllerSetting();
        eventController.setEventType(eventType);
        eventController.setController(controller);
        this.eventControllers.setItem(eventController);
        return this;
    }

    public EzySettingsBuilder addEventController(EzyEventType eventType, Class<?> controller) {
        return this.addEventController(eventType.getName(), controller.getName());
    }

    public EzySettingsBuilder zone(EzySimpleZoneSetting zone) {
        this.zones.setItem(zone);
        return this;
    }

    public EzySettingsBuilder zones(EzySimpleZonesSetting zones) {
        this.zones = zones;
        return this;
    }

    public EzySimpleSettings build() {
        EzySimpleSettings p = new EzySimpleSettings();
        p.setDebug(this.debug);
        p.setNodeName(this.nodeName);
        p.setMaxSessions(this.maxSessions);
        p.setStreaming(this.streaming);
        p.setHttp(this.http);
        p.setSocket(this.socket);
        p.setUdp(this.udp);
        p.setAdmins(this.admins);
        p.setLogger(this.logger);
        p.setWebsocket(this.websocket);
        p.setThreadPoolSize(this.threadPoolSize);
        p.setSessionManagement(this.sessionManagement);
        p.setEventControllers(this.eventControllers);
        for (EzyZoneSetting zone : this.zones.getZones()) {
            p.addZone((EzySimpleZoneSetting)zone);
        }
        return p;
    }
}

