/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.io;

import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.entity.EzyArray;
import com.tvd12.ezyfox.entity.EzyObject;
import com.tvd12.ezyfox.function.EzyToObject;
import com.tvd12.ezyfox.io.EzyDataConverter;
import com.tvd12.ezyfox.io.EzyDates;
import com.tvd12.ezyfox.io.EzyInputTransformer;
import com.tvd12.ezyfox.util.EzyEntityBuilders;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EzySimpleInputTransformer
extends EzyEntityBuilders
implements EzyInputTransformer {
    private static final long serialVersionUID = 5436415615070699119L;
    protected final Map<Class, EzyToObject> transformers = this.defaultTransformers();

    @Override
    public Object transform(Object value) {
        return value == null ? this.transformNullValue() : this.transformNonNullValue(value);
    }

    protected Object transformNullValue() {
        return null;
    }

    protected Object transformNonNullValue(Object value) {
        return this.transformNonNullValue(value, this.transformers);
    }

    protected Object transformNonNullValue(Object value, Map<Class, EzyToObject> transformers) {
        return this.transformNonNullValue(value, value.getClass(), transformers);
    }

    protected Object transformNonNullValue(Object value, Class type, Map<Class, EzyToObject> transformers) {
        EzyToObject trans = transformers.get(type);
        if (trans != null) {
            return trans.transform(value);
        }
        if (type.isEnum()) {
            return value.toString();
        }
        if (value instanceof Map) {
            return this.transformMap(value);
        }
        if (value instanceof EzyBuilder) {
            return this.transformBuilder(value);
        }
        return value;
    }

    protected Object transformMap(Object value) {
        EzyObject object = this.newObject();
        object.putAll((Map)value);
        return object;
    }

    protected Object transformBuilder(Object value) {
        return this.transformNonNullValue(((EzyBuilder)value).build());
    }

    private Map<Class, EzyToObject> defaultTransformers() {
        ConcurrentHashMap<Class, EzyToObject> answer = new ConcurrentHashMap<Class, EzyToObject>();
        this.addOtherTransformers(answer);
        this.addEntityTransformers(answer);
        this.addWrapperTransformers(answer);
        this.addWrapperArrayTransformers(answer);
        this.addPrimitiveArrayTransformers(answer);
        this.addTwoDimensionsWrapperArrayTransformers(answer);
        this.addTwoDimensionsPrimitiveArrayTransformers(answer);
        return answer;
    }

    protected void addWrapperTransformers(Map<Class, EzyToObject> answer) {
        answer.put(Boolean.class, value -> value);
        answer.put(Byte.class, value -> value);
        answer.put(Character.class, value -> (byte)value.charValue());
        answer.put(Double.class, value -> value);
        answer.put(Float.class, value -> value);
        answer.put(Integer.class, value -> value);
        answer.put(Long.class, value -> value);
        answer.put(Short.class, value -> value);
        answer.put(String.class, value -> value);
    }

    protected void addPrimitiveArrayTransformers(Map<Class, EzyToObject> answer) {
        answer.put(boolean[].class, EzyDataConverter::arrayToList);
        answer.put(byte[].class, value -> value);
        answer.put(char[].class, EzyDataConverter::charArrayToByteArray);
        answer.put(double[].class, EzyDataConverter::arrayToList);
        answer.put(float[].class, EzyDataConverter::arrayToList);
        answer.put(int[].class, EzyDataConverter::arrayToList);
        answer.put(long[].class, EzyDataConverter::arrayToList);
        answer.put(short[].class, EzyDataConverter::arrayToList);
        answer.put(String[].class, EzyDataConverter::arrayToList);
    }

    protected void addWrapperArrayTransformers(Map<Class, EzyToObject> answer) {
        answer.put(Boolean[].class, EzyDataConverter::arrayToList);
        answer.put(Byte[].class, EzyDataConverter::toPrimitiveByteArray);
        answer.put(Character[].class, EzyDataConverter::charWrapperArrayToPrimitiveByteArray);
        answer.put(Double[].class, EzyDataConverter::arrayToList);
        answer.put(Float[].class, EzyDataConverter::arrayToList);
        answer.put(Integer[].class, EzyDataConverter::arrayToList);
        answer.put(Long[].class, EzyDataConverter::arrayToList);
        answer.put(Short[].class, EzyDataConverter::arrayToList);
    }

    protected void addTwoDimensionsPrimitiveArrayTransformers(Map<Class, EzyToObject> answer) {
        answer.put(boolean[][].class, value -> (EzyArray)this.newArrayBuilder().append((T[])value).build());
        answer.put(byte[][].class, value -> (EzyArray)this.newArrayBuilder().append((T[])value).build());
        answer.put(char[][].class, value -> (EzyArray)this.newArrayBuilder().append((T[])value).build());
        answer.put(double[][].class, value -> (EzyArray)this.newArrayBuilder().append((T[])value).build());
        answer.put(float[][].class, value -> (EzyArray)this.newArrayBuilder().append((T[])value).build());
        answer.put(int[][].class, value -> (EzyArray)this.newArrayBuilder().append((T[])value).build());
        answer.put(long[][].class, value -> (EzyArray)this.newArrayBuilder().append((T[])value).build());
        answer.put(short[][].class, value -> (EzyArray)this.newArrayBuilder().append((T[])value).build());
    }

    protected void addTwoDimensionsWrapperArrayTransformers(Map<Class, EzyToObject> answer) {
        answer.put(Boolean[][].class, value -> (EzyArray)this.newArrayBuilder().append((T[])value).build());
        answer.put(Byte[][].class, value -> (EzyArray)this.newArrayBuilder().append((T[])value).build());
        answer.put(Character[][].class, value -> (EzyArray)this.newArrayBuilder().append((T[])value).build());
        answer.put(Double[][].class, value -> (EzyArray)this.newArrayBuilder().append((T[])value).build());
        answer.put(Float[][].class, value -> (EzyArray)this.newArrayBuilder().append((T[])value).build());
        answer.put(Integer[][].class, value -> (EzyArray)this.newArrayBuilder().append((T[])value).build());
        answer.put(Long[][].class, value -> (EzyArray)this.newArrayBuilder().append((T[])value).build());
        answer.put(Short[][].class, value -> (EzyArray)this.newArrayBuilder().append((T[])value).build());
        answer.put(String[][].class, value -> (EzyArray)this.newArrayBuilder().append((T[])value).build());
    }

    protected void addEntityTransformers(Map<Class, EzyToObject> answer) {
        answer.put(EzyObject[].class, value -> (EzyArray)this.newArrayBuilder().append((T[])value).build());
        answer.put(EzyObject[][].class, value -> (EzyArray)this.newArrayBuilder().append((T[])value).build());
    }

    protected void addOtherTransformers(Map<Class, EzyToObject> answer) {
        answer.put(Date.class, EzyDates::format);
        answer.put(LocalDate.class, value -> EzyDates.format((TemporalAccessor)value, (String)"yyyy-MM-dd"));
        answer.put(LocalTime.class, value -> EzyDates.format((TemporalAccessor)value, (String)"HH:mm:ss:SSS"));
        answer.put(LocalDateTime.class, EzyDates::format);
        answer.put(Class.class, Class::getName);
    }
}

