/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.stream;

import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.stream.EzyInputStreamLoader;
import java.io.InputStream;

public class EzyClassPathInputStreamLoader
implements EzyInputStreamLoader {
    protected final ClassLoader classLoader;

    public EzyClassPathInputStreamLoader() {
        this(EzyClassPathInputStreamLoader.builder());
    }

    protected EzyClassPathInputStreamLoader(Builder builder) {
        this.classLoader = builder.classLoader;
    }

    @Override
    public InputStream load(String filePath) {
        InputStream stream = this.firstLoad(filePath);
        return stream != null ? stream : this.secondLoad(filePath);
    }

    protected InputStream firstLoad(String filePath) {
        return this.classLoader.getResourceAsStream(filePath);
    }

    protected InputStream secondLoad(String filePath) {
        return this.firstLoad("/" + filePath);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements EzyBuilder<EzyInputStreamLoader> {
        protected ClassLoader classLoader = this.getClass().getClassLoader();

        public Builder context(Class<?> context) {
            return this.classLoader(context.getClassLoader());
        }

        public Builder classLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public EzyInputStreamLoader build() {
            return new EzyClassPathInputStreamLoader(this);
        }
    }
}

