/*
 * Decompiled with CFR 0.152.
 */
package com.ezyplatform.socket.monitor.plugin.controller;

import com.ezyplatform.socket.monitor.plugin.controller.AbstractController;
import com.ezyplatform.socket.monitor.plugin.data.CpuPoint;
import com.ezyplatform.socket.monitor.plugin.data.MemoryPoint;
import com.ezyplatform.socket.monitor.plugin.data.NetworkPoint;
import com.ezyplatform.socket.monitor.plugin.data.TrafficDetails;
import com.ezyplatform.socket.monitor.plugin.monitor.SystemMonitor;
import com.tvd12.ezyfox.annotation.EzyFeature;
import com.tvd12.ezyfox.core.annotation.EzyDoHandle;
import com.tvd12.ezyfox.core.annotation.EzyRequestController;
import com.tvd12.ezyfox.entity.EzyObject;
import com.tvd12.ezyfox.factory.EzyEntityFactory;
import com.tvd12.ezyfox.monitor.EzyCpuMonitor;
import com.tvd12.ezyfox.monitor.EzyGcMonitor;
import com.tvd12.ezyfox.monitor.EzyMemoryMonitor;
import com.tvd12.ezyfox.monitor.EzyThreadsMonitor;
import com.tvd12.ezyfox.monitor.data.EzyThreadsDetail;
import com.tvd12.ezyfox.util.EzyEntityObjects;
import com.tvd12.ezyfoxserver.statistics.EzyStatistics;

@EzyRequestController
public class StatisticsRequestController
extends AbstractController {
    @EzyFeature(value="devops")
    @EzyDoHandle(value="liveTime")
    public EzyObject liveTimeGet() {
        EzyStatistics statistics = this.getStatistics();
        long startupTime = statistics.getStartTime();
        long liveTime = (System.currentTimeMillis() - startupTime) / 1000L;
        return EzyEntityObjects.newObject((Object)"liveTime", (Object)liveTime);
    }

    @EzyFeature(value="devops")
    @EzyDoHandle(value="activeThreads")
    public EzyThreadsDetail activeThreadsGet() {
        return SystemMonitor.getInstance().getThreadsMonitor().getThreadsDetails();
    }

    @EzyFeature(value="management")
    @EzyDoHandle(value="concurrentSessions")
    public EzyObject currentSessionsGet() {
        int allSessionCount = this.getServer().getSessionManager().getAllSessionCount();
        return EzyEntityObjects.newObject((Object)"count", (Object)allSessionCount);
    }

    @EzyFeature(value="management")
    @EzyDoHandle(value="concurrentUsers")
    public EzyObject currentUsersGet() {
        int allUserCount = this.getServerContext().getZoneContexts().stream().mapToInt(it -> it.getZone().getUserManager().getUserCount()).sum();
        return EzyEntityObjects.newObject((Object)"count", (Object)allUserCount);
    }

    @EzyFeature(value="devops")
    @EzyDoHandle(value="cpuUsage")
    public CpuPoint cpuUsageGet() {
        SystemMonitor monitor = SystemMonitor.getInstance();
        EzyGcMonitor gcMonitor = monitor.getGcMonitor();
        EzyCpuMonitor cpuMonitor = monitor.getCpuMonitor();
        return CpuPoint.builder().systemCpuLoad(cpuMonitor.getSystemCpuLoad()).processCpuLoad(cpuMonitor.getProcessCpuLoad()).processGcActivity(gcMonitor.getProcessGcActivity()).build();
    }

    @EzyFeature(value="devops")
    @EzyDoHandle(value="memoryUsage")
    public MemoryPoint memoryUsageGet() {
        EzyMemoryMonitor memoryMonitor = SystemMonitor.getInstance().getMemoryMonitor();
        return MemoryPoint.builder().maxMemory(memoryMonitor.getMaxMemory()).freeMemory(memoryMonitor.getFreeMemory()).totalMemory(memoryMonitor.getTotalMemory()).build();
    }

    @EzyFeature(value="devops")
    @EzyDoHandle(value="networkTraffic")
    public NetworkPoint networkTrafficGet() {
        return new NetworkPoint(this.getStatistics());
    }

    @EzyFeature(value="devops")
    @EzyDoHandle(value="threadCount")
    public EzyObject threadsGet() {
        EzyThreadsMonitor threadsMonitor = SystemMonitor.getInstance().getThreadsMonitor();
        int threadCount = threadsMonitor.getThreadCount();
        int daemonThreadCount = threadsMonitor.getDaemonThreadCount();
        return (EzyObject)EzyEntityFactory.newObjectBuilder().append((Object)"threadCount", (Object)threadCount).append((Object)"daemonThreadCount", (Object)daemonThreadCount).build();
    }

    @EzyFeature(value="devops")
    @EzyDoHandle(value="trafficDetails")
    public TrafficDetails trafficDetails() {
        return new TrafficDetails(this.getStatistics());
    }

    private EzyStatistics getStatistics() {
        return this.getServer().getStatistics();
    }
}

