/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.installer.io;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.util.Collections;
import org.youngmonkeys.ezyplatform.installer.io.InstallFolderProxy;

public class InstallerHistoryWriter {
    private InstallerHistoryWriter() {
    }

    public static void writeToHistory(String message) {
        Path logsFolder = InstallFolderProxy.getLogsFolder();
        Path historyFile = Paths.get(logsFolder.toString(), "cli-history.txt");
        try {
            if (!Files.exists(logsFolder, new LinkOption[0])) {
                Files.createDirectory(logsFolder, new FileAttribute[0]);
            }
            if (!Files.exists(historyFile, new LinkOption[0])) {
                Files.createFile(historyFile, new FileAttribute[0]);
            }
            String line = LocalDateTime.now() + ": " + message;
            Files.write(historyFile, Collections.singletonList(line), StandardOpenOption.APPEND);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can not write history to " + historyFile + ", please check your permission");
        }
    }
}

