/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.manager;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.io.EzyDates;
import com.tvd12.ezyfox.util.EzyArrayUtil;
import java.io.File;
import java.nio.file.Paths;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.manager.AdminFileSystemManager;
import org.youngmonkeys.ezyplatform.admin.manager.AdminModuleManager;
import org.youngmonkeys.ezyplatform.entity.ModuleType;
import org.youngmonkeys.ezyplatform.entity.TargetType;
import org.youngmonkeys.ezyplatform.io.FolderProxy;

@EzySingleton
public class AdminModulesBackupWriter {
    private final AdminFileSystemManager fileSystemManager;

    public void backup(String projectName) {
        String nowTimeFolder = EzyDates.format((long)System.currentTimeMillis(), (String)"yyyy-MM-dd'T'HH-mm-ss");
        File projectFolder = this.fileSystemManager.getUploadProjectFolder(projectName);
        for (TargetType targetType : TargetType.values()) {
            File targetFolder = Paths.get(projectFolder.toString(), targetType.getName()).toFile();
            if (!targetFolder.exists()) continue;
            this.backupOldModules(targetType, targetFolder, projectFolder, nowTimeFolder);
        }
    }

    private void backupOldModules(TargetType targetType, File targetFolder, File modulesRootFolder, String nowTimeFolder) {
        ModuleType[] moduleTypes;
        for (ModuleType moduleType : moduleTypes = AdminModuleManager.MODULE_TYPES_BY_TARGET.get(targetType)) {
            File modulesFolder = Paths.get(targetFolder.toString(), moduleType.getContainerFolder()).toFile();
            if (!modulesFolder.exists()) continue;
            this.backupOldModules(targetType, moduleType, modulesFolder, modulesRootFolder, nowTimeFolder);
        }
    }

    private void backupOldModules(TargetType targetType, ModuleType moduleType, File modulesFolder, File modulesRootFolder, String nowTimeFolder) {
        Object[] moduleFolders = modulesFolder.listFiles();
        if (EzyArrayUtil.isEmpty((Object[])moduleFolders)) {
            return;
        }
        for (Object moduleFolder : moduleFolders) {
            File moduleSubPath = FolderProxy.subpath((File)moduleFolder, (File)modulesRootFolder);
            File oldModuleFolder = this.fileSystemManager.concatWithEzyHome(moduleSubPath.toPath());
            if (!oldModuleFolder.exists()) continue;
            File backupFolder = Paths.get(this.fileSystemManager.getBackupFolder().toString(), nowTimeFolder, targetType.getName(), moduleType.getContainerFolder(), ((File)moduleFolder).getName()).toFile();
            FolderProxy.copyFolder((File)oldModuleFolder, (File)backupFolder);
        }
    }

    @Generated
    public AdminModulesBackupWriter(AdminFileSystemManager fileSystemManager) {
        this.fileSystemManager = fileSystemManager;
    }
}

