/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.cli.manager;

import com.tvd12.ezyfox.util.EzyLoggable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.youngmonkeys.ezyplatform.cli.data.Target;
import org.youngmonkeys.ezyplatform.cli.io.CliTargetInformationInteractor;
import org.youngmonkeys.ezyplatform.entity.TargetType;

public final class CliTargetManager
extends EzyLoggable {
    private final Map<TargetType, Target> targets = new HashMap<TargetType, Target>();
    private static final CliTargetManager INSTANCE = new CliTargetManager();

    private CliTargetManager() {
    }

    public static CliTargetManager getInstance() {
        return INSTANCE;
    }

    public void activateTarget(TargetType targetType) throws IOException {
        Target target = this.getTarget(targetType);
        target.setActive(true);
        this.saveTarget(target);
    }

    public void deactivateTarget(TargetType targetType) throws IOException {
        if (targetType == TargetType.ADMIN) {
            return;
        }
        Target target = this.getTarget(targetType);
        target.setActive(false);
        this.saveTarget(target);
    }

    private void saveTarget(Target target) throws IOException {
        CliTargetInformationInteractor.getInstance().saveTarget(target);
    }

    public boolean isTargetActivated(TargetType targetType) {
        Target target = this.getTarget(targetType);
        return target.isEnable() && target.isActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Target getTarget(TargetType type) {
        if (this.targets.isEmpty()) {
            Map<TargetType, Target> map = this.targets;
            synchronized (map) {
                if (this.targets.isEmpty()) {
                    this.targets.putAll(this.readTargetMap());
                }
            }
        }
        return this.targets.get(type);
    }

    private Map<TargetType, Target> readTargetMap() {
        return CliTargetInformationInteractor.getInstance().readTargetMap();
    }
}

