/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.codec;

import com.tvd12.ezyfox.codec.MsgPackConstant;
import com.tvd12.ezyfox.io.EzyBytes;
import com.tvd12.ezyfox.io.EzyCastToByte;

public class MsgPackBinSizeSerializer
implements EzyCastToByte {
    private static final MsgPackBinSizeSerializer INSTANCE = new MsgPackBinSizeSerializer();

    private MsgPackBinSizeSerializer() {
    }

    public static MsgPackBinSizeSerializer getInstance() {
        return INSTANCE;
    }

    public byte[] serialize(int size) {
        if (size <= MsgPackConstant.MAX_BIN8_SIZE) {
            return this.parse8(size);
        }
        if (size <= MsgPackConstant.MAX_BIN16_SIZE) {
            return this.parse16(size);
        }
        return this.parse32(size);
    }

    private byte[] parse8(int size) {
        return new byte[]{this.cast(196), this.cast(size)};
    }

    private byte[] parse16(int size) {
        return EzyBytes.getBytes((int)197, (int)size, (int)2);
    }

    private byte[] parse32(int size) {
        return EzyBytes.getBytes((int)198, (int)size, (int)4);
    }
}

