/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.codec;

import com.tvd12.ezyfox.codec.MsgPackConstant;
import com.tvd12.ezyfox.io.EzyBytes;
import com.tvd12.ezyfox.io.EzyCastToByte;

public class MsgPackStringSizeSerializer
implements EzyCastToByte {
    private static final MsgPackStringSizeSerializer INSTANCE = new MsgPackStringSizeSerializer();

    private MsgPackStringSizeSerializer() {
    }

    public static MsgPackStringSizeSerializer getInstance() {
        return INSTANCE;
    }

    public byte[] serialize(int size) {
        if (size <= MsgPackConstant.MAX_FIXSTR_SIZE) {
            return this.parseFix(size);
        }
        if (size <= MsgPackConstant.MAX_STR8_SIZE) {
            return this.parse8(size);
        }
        if (size <= MsgPackConstant.MAX_STR16_SIZE) {
            return this.parse16(size);
        }
        return this.parse32(size);
    }

    private byte[] parseFix(int size) {
        return new byte[]{this.cast(0xA0 | size)};
    }

    private byte[] parse8(int size) {
        return EzyBytes.getBytes((int)217, (int)size, (int)1);
    }

    private byte[] parse16(int size) {
        return EzyBytes.getBytes((int)218, (int)size, (int)2);
    }

    private byte[] parse32(int size) {
        return EzyBytes.getBytes((int)219, (int)size, (int)4);
    }
}

