/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.codec;

import com.tvd12.ezyfox.codec.EzyMessageSerializer;
import com.tvd12.ezyfox.exception.EzyCodecException;
import com.tvd12.ezyfox.function.EzyParser;
import com.tvd12.ezyfox.io.EzyMaps;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class EzyAbstractSerializer<T>
implements EzyMessageSerializer {
    protected Map<Class<?>, EzyParser<Object, T>> parsers = this.defaultParsers();

    protected T parseNotNull(Object value) {
        EzyParser<Object, T> parser = this.getParser(value.getClass());
        if (parser != null) {
            return this.parseWithParser(parser, value);
        }
        return this.parseWithNoParser(value);
    }

    protected T parseWithParser(EzyParser<Object, T> parser, Object value) {
        return (T)parser.parse(value);
    }

    protected T parseWithNoParser(Object value) {
        throw new EzyCodecException("has no parse for " + value.getClass());
    }

    protected abstract T parseNil();

    protected EzyParser<Object, T> getParser(Class<?> type) {
        return (EzyParser)EzyMaps.getValue(this.parsers, type);
    }

    protected Map<Class<?>, EzyParser<Object, T>> defaultParsers() {
        ConcurrentHashMap parsers = new ConcurrentHashMap();
        this.addParsers(parsers);
        return parsers;
    }

    protected abstract void addParsers(Map<Class<?>, EzyParser<Object, T>> var1);
}

