/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.io;

import com.tvd12.ezyfox.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class EzySets {
    private EzySets() {
    }

    public static <E> Set<E> combine(Collection<E> ... sets) {
        HashSet<E> all = new HashSet<E>();
        for (Collection<E> set : sets) {
            all.addAll(set);
        }
        return all;
    }

    public static <I, O> Set<O> newHashSetByAddAll(Collection<I> coll, Function<I, Collection<O>> trans) {
        HashSet<O> set = new HashSet<O>();
        for (I input : coll) {
            set.addAll(trans.apply(input));
        }
        return set;
    }

    public static <T> Set<T> filter(Collection<T> coll, Predicate<T> predicate) {
        return coll.stream().filter(predicate).collect(Collectors.toSet());
    }

    public static <T> Set<T> newHashSet(Collection<T> coll, Collection<T> except) {
        HashSet<T> answer = new HashSet<T>();
        for (T item : coll) {
            if (except.contains(item)) continue;
            answer.add(item);
        }
        return answer;
    }

    public static <T> Set<T> newHashSet(Collection<T> coll, T ... except) {
        return EzySets.newHashSet(coll, Arrays.asList(except));
    }

    public static <I, O> Set<O> newHashSet(I[] input, Function<I, O> refactor) {
        return EzySets.newHashSet(Sets.newHashSet(input), refactor);
    }

    public static <I, O> Set<O> newHashSet(Collection<I> input, Function<I, O> refactor) {
        HashSet<O> answer = new HashSet<O>();
        for (I value : input) {
            answer.add(refactor.apply(value));
        }
        return answer;
    }

    public static <K, V, O> Set<O> newHashSet(Map<K, V> input, BiFunction<K, V, O> refactor) {
        HashSet<O> answer = new HashSet<O>();
        for (K key : input.keySet()) {
            answer.add(refactor.apply(key, input.get(key)));
        }
        return answer;
    }

    public static <T> Set<T> addElementsToNewSet(Collection<T> coll, T ... elements) {
        HashSet<T> answer = new HashSet<T>(coll);
        answer.addAll(Arrays.asList(elements));
        return answer;
    }
}

