/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.reflect;

import com.tvd12.ezyfox.collect.Lists;
import com.tvd12.ezyfox.reflect.EzyMethod;
import com.tvd12.ezyfox.reflect.EzyMethodFinder;
import com.tvd12.reflections.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;

public final class EzyMethods {
    private EzyMethods() {
    }

    public static String getFieldNameOfGetter(Method method) {
        String name = method.getName();
        if (name.length() <= 3) {
            return name;
        }
        if (name.startsWith("get")) {
            return EzyMethods.getFieldName(method, 3);
        }
        if (name.startsWith("is")) {
            return EzyMethods.getFieldName(method, 2);
        }
        return name;
    }

    public static String getFieldNameOfSetter(Method method) {
        String name = method.getName();
        if (name.length() <= 3) {
            return name;
        }
        if (name.startsWith("set")) {
            return EzyMethods.getFieldName(method, 3);
        }
        return name;
    }

    public static String getFieldName(Method method, int prefixLength) {
        String name = method.getName();
        name = name.substring(prefixLength);
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }

    public static Object invoke(Method method, Object obj, Object ... args) {
        try {
            return method.invoke(obj, args);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can not call method " + method.getName(), e);
        }
    }

    public static List<Method> getMethods(Class clazz) {
        return ReflectionUtils.getAllMethodList((Class)clazz, (Predicate[])new Predicate[0]);
    }

    public static Method getMethod(Class clazz, String methodName, Class ... parameterTypes) {
        return new EzyMethodFinder(clazz, methodName, parameterTypes).find();
    }

    public static Method getPublicMethod(Class clazz, String methodName, Class ... parameterTypes) {
        if (clazz == null) {
            return null;
        }
        try {
            Method method = clazz.getDeclaredMethod(methodName, parameterTypes);
            if (Modifier.isPublic(method.getModifiers())) {
                return method;
            }
            return null;
        }
        catch (NoSuchMethodException e) {
            Class<?>[] interfaces;
            for (Class<?> itf : interfaces = clazz.getInterfaces()) {
                Method method = EzyMethods.getPublicMethod(itf, methodName, parameterTypes);
                if (method == null) continue;
                return method;
            }
            Class supperClass = clazz.getSuperclass();
            return EzyMethods.getPublicMethod(supperClass, methodName, parameterTypes);
        }
    }

    public static List<Method> getAnnotatedMethods(Class clazz, Class<? extends Annotation> annClass) {
        ArrayList<Method> answer = new ArrayList<Method>();
        EzyMethods.getAnnotatedMethods(clazz, annClass, answer);
        return answer;
    }

    private static void getAnnotatedMethods(Class clazz, Class<? extends Annotation> annClass, List<Method> output) {
        Class<?>[] interfaces;
        Method[] methods;
        if (clazz == null || clazz.equals(Object.class)) {
            return;
        }
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(annClass)) continue;
            output.add(method);
        }
        EzyMethods.getAnnotatedMethods(clazz.getSuperclass(), annClass, output);
        for (Class<?> itf : interfaces = clazz.getInterfaces()) {
            EzyMethods.getAnnotatedMethods(itf, annClass, output);
        }
    }

    public static List<Method> getDeclaredMethods(Class clazz) {
        return Lists.newArrayList(clazz.getDeclaredMethods());
    }

    public static List<Method> getPublicMethods(Class clazz) {
        List<Method> methods = EzyMethods.getMethods(clazz);
        ArrayList<Method> answer = new ArrayList<Method>();
        for (Method method : methods) {
            if (!Modifier.isPublic(method.getModifiers())) continue;
            answer.add(method);
        }
        return answer;
    }

    public static List<Method> filterOverriddenMethods(List<Method> allMethods) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method i : allMethods) {
            boolean valid = true;
            for (Method k : methods) {
                if (!EzyMethods.isOverriddenMethod(i, k)) continue;
                valid = false;
                break;
            }
            if (!valid) continue;
            methods.add(i);
        }
        return methods;
    }

    public static List<EzyMethod> filterOverriddenMethods(Collection<EzyMethod> allMethods) {
        ArrayList<EzyMethod> methods = new ArrayList<EzyMethod>();
        for (EzyMethod i : allMethods) {
            boolean valid = true;
            for (EzyMethod k : methods) {
                if (!EzyMethods.isOverriddenMethod(i, k)) continue;
                valid = false;
                break;
            }
            if (!valid) continue;
            methods.add(i);
        }
        return methods;
    }

    public static boolean isOverriddenMethod(EzyMethod a, EzyMethod b) {
        return EzyMethods.isOverriddenMethod(a.getMethod(), b.getMethod());
    }

    public static boolean isOverriddenMethod(Method a, Method b) {
        try {
            if (a.equals(b)) {
                return false;
            }
            if (a.getName().equals(b.getName())) {
                Class<?> dcb;
                boolean answer = false;
                Class<?> dca = a.getDeclaringClass();
                if (dca.equals(dcb = b.getDeclaringClass())) {
                    return false;
                }
                if (dca.isAssignableFrom(dcb)) {
                    try {
                        dcb.getDeclaredMethod(a.getName(), a.getParameterTypes());
                        answer = true;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                } else if (dcb.isAssignableFrom(dca)) {
                    try {
                        dca.getDeclaredMethod(b.getName(), b.getParameterTypes());
                        answer = true;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                return answer;
            }
            return false;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't check overridden of method: " + a + ", " + b, e);
        }
    }
}

