/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.reflect;

import com.tvd12.ezyfox.asm.EzyFunction;
import com.tvd12.ezyfox.asm.EzyInstruction;
import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.reflect.EzyClasses;
import com.tvd12.ezyfox.reflect.EzyField;
import com.tvd12.ezyfox.reflect.EzyMethod;
import com.tvd12.ezyfox.reflect.EzyMethods;
import com.tvd12.ezyfox.util.EzyLoggable;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtNewMethod;
import lombok.Generated;

public class EzySetterBuilder
extends EzyLoggable
implements EzyBuilder<BiConsumer> {
    protected static final AtomicInteger COUNT = new AtomicInteger(0);
    protected static boolean debug;
    protected EzyField field;
    protected EzyMethod method;
    protected Class<?> declaringClass;

    public EzySetterBuilder field(EzyField field) {
        this.field = field;
        this.declaringClass = field.getField().getDeclaringClass();
        return this;
    }

    public EzySetterBuilder method(EzyMethod method) {
        this.method = method;
        this.declaringClass = method.getMethod().getDeclaringClass();
        return this;
    }

    @Override
    public BiConsumer build() {
        try {
            return this.doBuild();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("build setter: " + this.field + " error", e);
        }
    }

    protected BiConsumer doBuild() throws Exception {
        String implClassName = this.getImplClassName();
        ClassPool pool = ClassPool.getDefault();
        CtClass implClass = pool.makeClass(implClassName);
        String acceptMethodContent = this.makeAcceptMethodContent();
        this.printMethodContent(acceptMethodContent);
        implClass.addMethod(CtNewMethod.make((String)acceptMethodContent, (CtClass)implClass));
        implClass.setInterfaces(new CtClass[]{pool.get(BiConsumer.class.getName())});
        Class answerClass = implClass.toClass();
        implClass.detach();
        return (BiConsumer)EzyClasses.newInstance(answerClass);
    }

    protected String makeAcceptMethodContent() {
        String methodName;
        Class type;
        if (this.field != null) {
            type = this.field.getType();
            methodName = this.field.getSetterMethod();
        } else {
            type = this.method.getParameterTypes()[0];
            methodName = this.method.getName();
        }
        return new EzyFunction(this.getEntityTypeMethod()).body().append(new EzyInstruction("\t", "\n").cast(this.declaringClass, "arg0").dot().append(methodName).bracketopen().cast(type, "arg1").bracketclose()).function().toString();
    }

    protected EzyMethod getEntityTypeMethod() {
        Method method = EzyMethods.getMethod(BiConsumer.class, "accept", Object.class, Object.class);
        return new EzyMethod(method);
    }

    protected String getImplClassName() {
        String name = this.field != null ? this.field.getName() : this.method.getFieldName();
        return this.declaringClass.getName() + "$" + name + "$EzyObjectProxy$SetterImpl$" + COUNT.incrementAndGet();
    }

    protected void printMethodContent(String methodContent) {
        if (debug) {
            this.logger.info("method content \n{}", (Object)methodContent);
        }
    }

    @Generated
    public static void setDebug(boolean debug) {
        EzySetterBuilder.debug = debug;
    }
}

