/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.util;

import com.tvd12.ezyfox.collect.Sets;
import com.tvd12.ezyfox.util.EzyReturner;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;

public final class EzyFileUtil {
    public static final char EXTENSION_SEPARATOR = '.';
    private static final int NOT_FOUND = -1;
    private static final String EMPTY_STRING = "";
    private static final Predicate<File> EMPTY_FILTER = t -> true;

    private EzyFileUtil() {
    }

    public static Collection<File> listFiles(File directory, boolean recursive) {
        return EzyFileUtil.listFiles(directory, EMPTY_FILTER, recursive);
    }

    public static Collection<File> listFiles(File directory, String[] extensions, boolean recursive) {
        return EzyFileUtil.listFiles(directory, Sets.newHashSet(extensions), recursive);
    }

    public static Collection<File> listFiles(File directory, Set<String> extensions, boolean recursive) {
        ExtensionsFilter filter = new ExtensionsFilter(extensions);
        return EzyFileUtil.listFiles(directory, filter, recursive);
    }

    public static Collection<File> listFiles(File directory, Predicate<File> filter, boolean recursive) {
        ArrayList<File> files = new ArrayList<File>();
        EzyFileUtil.listFiles0(directory, filter, recursive, files);
        return files;
    }

    private static void listFiles0(File directory, Predicate<File> filter, boolean recursive, Collection<File> output) {
        File[] files;
        for (File file : files = EzyReturner.returnNotNull(directory.listFiles(), new File[0])) {
            if (file.isDirectory() || !filter.test(file)) continue;
            output.add(file);
        }
        if (recursive) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                EzyFileUtil.listFiles0(file, filter, true, output);
            }
        }
    }

    public static String getFileExtension(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return EMPTY_STRING;
        }
        return fileName.substring(index + 1);
    }

    public static boolean createFileIfNotExists(File file) throws IOException {
        if (!file.exists()) {
            File parentFile = file.getParentFile();
            if (parentFile != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            return file.createNewFile();
        }
        return false;
    }

    public static String getFileName(String filePath) {
        int index = filePath.lastIndexOf(47);
        if (index < 0) {
            return filePath;
        }
        if (index >= filePath.length() - 1) {
            return filePath;
        }
        return filePath.substring(index + 1);
    }

    public static String getFileNameWithoutExtension(String filePath) {
        String fileName = EzyFileUtil.getFileName(filePath);
        int index = fileName.lastIndexOf(46);
        if (index == 0) {
            return EMPTY_STRING;
        }
        if (index > 0) {
            return fileName.substring(0, index);
        }
        return fileName;
    }

    public static void copyFile(File from, File to) throws IOException {
        EzyFileUtil.createFileIfNotExists(to);
        Files.copy(from.toPath(), to.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    private static class ExtensionsFilter
    implements Predicate<File> {
        private final Set<String> extensions;

        public ExtensionsFilter(Set<String> extensions) {
            this.extensions = extensions;
        }

        @Override
        public boolean test(File file) {
            String fileName = file.getName();
            String fileExtension = EzyFileUtil.getFileExtension(fileName);
            return this.extensions.contains(fileExtension);
        }
    }
}

