/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.codec;

import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.codec.EzyDecodeHandler;
import com.tvd12.ezyfox.codec.EzyDecodeState;
import com.tvd12.ezyfox.codec.EzyIDecodeState;
import com.tvd12.ezyfox.codec.EzyMessage;
import com.tvd12.ezyfox.util.EzyResettable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;

public abstract class EzyDecodeHandlers
implements EzyResettable {
    protected EzyIDecodeState state = this.firstState();
    protected Map<EzyIDecodeState, EzyDecodeHandler> handlers;

    protected EzyDecodeHandlers(Builder builder) {
        this.handlers = builder.newHandlers();
    }

    public void handle(ByteBuffer in, Queue<EzyMessage> out) {
        for (EzyDecodeHandler handler = this.handlers.get(this.state); handler != null && handler.handle(in, out); handler = handler.nextHandler()) {
            this.state = handler.nextState();
        }
    }

    protected EzyIDecodeState firstState() {
        return EzyDecodeState.PREPARE_MESSAGE;
    }

    public void reset() {
        this.state = this.firstState();
    }

    public static abstract class Builder
    implements EzyBuilder<EzyDecodeHandlers> {
        protected Map<EzyIDecodeState, EzyDecodeHandler> newHandlers() {
            HashMap<EzyIDecodeState, EzyDecodeHandler> answer = new HashMap<EzyIDecodeState, EzyDecodeHandler>();
            this.addHandlers(answer);
            return answer;
        }

        protected abstract void addHandlers(Map<EzyIDecodeState, EzyDecodeHandler> var1);
    }
}

