/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.controller;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyhttp.core.constant.HttpMethod;
import com.tvd12.ezyhttp.core.response.ResponseEntity;
import com.tvd12.ezyhttp.server.core.handler.UnhandledErrorHandler;
import com.tvd12.ezyhttp.server.core.manager.RequestURIManager;
import com.tvd12.ezyhttp.server.core.view.Redirect;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.data.Menu;
import org.youngmonkeys.ezyplatform.admin.data.MenuItem;
import org.youngmonkeys.ezyplatform.admin.manager.AdminEnvironmentManager;
import org.youngmonkeys.ezyplatform.admin.manager.AdminMenuManager;
import org.youngmonkeys.ezyplatform.admin.view.AdminViewFactory;
import org.youngmonkeys.ezyplatform.util.HttpRequests;

@EzySingleton
public class AdminGlobalErrorHandler
extends EzyLoggable
implements UnhandledErrorHandler {
    private final AdminViewFactory viewFactory;
    private final AdminMenuManager menuManager;
    private final RequestURIManager requestUriManager;
    private final AdminEnvironmentManager environmentManager;

    public Object processError(HttpMethod method, HttpServletRequest request, HttpServletResponse response, int errorStatusCode, Exception exception) {
        MenuItem menuItem;
        boolean isApiUri;
        this.logger.info("process error for request uri: {}, params: {}", new Object[]{request.getRequestURI(), request.getQueryString(), exception});
        String matchedUri = (String)request.getAttribute("ezyAttributeMatchedURI");
        if (matchedUri == null) {
            matchedUri = request.getRequestURI();
        }
        boolean bl = isApiUri = method != HttpMethod.GET || this.requestUriManager.isApiURI(method, matchedUri);
        if (isApiUri) {
            return this.toResponseEntity(errorStatusCode, exception);
        }
        Menu menu = this.menuManager.getMenuByUri(matchedUri);
        if (menu == null && (menuItem = this.menuManager.getMenuItemByUri(matchedUri)) != null) {
            menu = this.menuManager.getMenuByFullName(menuItem.getMenuFullName());
        }
        if (menu == null) {
            return this.processError(request, errorStatusCode, exception);
        }
        return this.viewFactory.newViewBuilder().template("default-menus").addVariable("menu", (Object)menu).build();
    }

    private Object processError(HttpServletRequest request, int errorStatusCode, Exception exception) {
        if (this.environmentManager.isDebugMode()) {
            return this.toResponseEntity(errorStatusCode, exception);
        }
        if (errorStatusCode == 406) {
            return ResponseEntity.status((int)406).build();
        }
        if (errorStatusCode == 500) {
            return Redirect.builder().uri(HttpRequests.addLanguageToUri((HttpServletRequest)request, (String)"/server-error")).addAttribute("exceptionMessage", (Object)EzyStrings.exceptionToSimpleString((Throwable)exception)).build();
        }
        if (errorStatusCode == 400) {
            return Redirect.to((String)HttpRequests.addLanguageToUri((HttpServletRequest)request, (String)"/bad-request"));
        }
        return Redirect.to((String)HttpRequests.addLanguageToUri((HttpServletRequest)request, (String)"/not-found"));
    }

    private ResponseEntity toResponseEntity(int errorStatusCode, Exception exception) {
        return ResponseEntity.status((int)errorStatusCode).body(Collections.singletonMap("error", exception != null ? exception.getClass().getName() : String.valueOf(errorStatusCode))).build();
    }

    @Generated
    public AdminGlobalErrorHandler(AdminViewFactory viewFactory, AdminMenuManager menuManager, RequestURIManager requestUriManager, AdminEnvironmentManager environmentManager) {
        this.viewFactory = viewFactory;
        this.menuManager = menuManager;
        this.requestUriManager = requestUriManager;
        this.environmentManager = environmentManager;
    }
}

