/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.manager;

import com.tvd12.ezyfox.bean.annotation.EzyPostInit;
import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyhttp.client.HttpClient;
import com.tvd12.ezyhttp.client.request.DownloadRequest;
import com.tvd12.ezyhttp.core.data.MultiValueMap;
import java.io.File;
import java.nio.file.Paths;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.data.ProjectInstallation;
import org.youngmonkeys.ezyplatform.admin.exception.ProjectInstallationException;
import org.youngmonkeys.ezyplatform.admin.manager.AdminEnvironmentManager;
import org.youngmonkeys.ezyplatform.admin.manager.AdminEzyPlatformFileManager;
import org.youngmonkeys.ezyplatform.admin.manager.AdminEzyPlatformKeyManager;
import org.youngmonkeys.ezyplatform.admin.manager.AdminFileSystemManager;
import org.youngmonkeys.ezyplatform.admin.manager.AdminMarketUrlManager;
import org.youngmonkeys.ezyplatform.admin.manager.AdminModuleManager;
import org.youngmonkeys.ezyplatform.admin.manager.AdminModulesBackupWriter;
import org.youngmonkeys.ezyplatform.admin.manager.AdminProjectInstallationQueue;
import org.youngmonkeys.ezyplatform.admin.manager.AdminTargetManager;
import org.youngmonkeys.ezyplatform.admin.service.AdminProjectService;
import org.youngmonkeys.ezyplatform.entity.ModuleType;
import org.youngmonkeys.ezyplatform.entity.TargetType;
import org.youngmonkeys.ezyplatform.io.FileNameProxy;
import org.youngmonkeys.ezyplatform.io.FolderProxy;
import org.youngmonkeys.ezyplatform.io.ZipFileProxy;

@EzySingleton
public class AdminNewModulesWatcher
extends EzyLoggable {
    private final HttpClient httpClient;
    private final AdminProjectService projectService;
    private final AdminEnvironmentManager environmentManager;
    private final AdminFileSystemManager fileSystemManager;
    private final AdminMarketUrlManager marketUrlManager;
    private final AdminModuleManager moduleManager;
    private final AdminEzyPlatformFileManager platformFileManager;
    private final AdminEzyPlatformKeyManager platformKeyManager;
    private final AdminModulesBackupWriter modulesBackupWriter;
    private final AdminProjectInstallationQueue projectInstallationQueue;
    private final AtomicBoolean active = new AtomicBoolean();

    @EzyPostInit
    public void postInit() {
        File uploadModulesFolder = this.fileSystemManager.getUploadModulesFolder();
        FolderProxy.clearFolder((File)uploadModulesFolder);
        this.startWatcherThread(uploadModulesFolder);
    }

    public void stop() {
        this.active.set(false);
    }

    private void startWatcherThread(File uploadModulesFolder) {
        Thread newThread = new Thread(() -> {
            this.active.set(true);
            ProjectInstallation installation = null;
            while (this.active.get()) {
                Exception exception = null;
                try {
                    installation = this.projectInstallationQueue.take();
                    this.watchNewProjectInstallation(installation, uploadModulesFolder);
                    this.projectService.addProject(installation.toAddProjectModel());
                }
                catch (Exception e) {
                    exception = e;
                    this.logger.warn("watch new modules error", (Throwable)e);
                }
                if (installation == null) continue;
                installation.finish(exception);
                this.projectInstallationQueue.finishInstallation(installation.getProjectName());
            }
        });
        newThread.setName("new-modules-watcher");
        newThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void watchNewProjectInstallation(ProjectInstallation installation, File uploadModulesFolder) throws Exception {
        String fileName;
        String projectName = installation.getProjectName();
        String projectVersion = installation.getVersion();
        if (installation.isUploaded()) {
            fileName = installation.getFileName();
        } else {
            String downloadFileUrl = this.marketUrlManager.getDownloadProjectUrl(this.environmentManager.getPlatformVersion(), projectName, projectVersion);
            DownloadRequest request = new DownloadRequest().setFileURL(downloadFileUrl).setHeaders(MultiValueMap.builder().setValue("platformKey", this.platformKeyManager.getPlatformKey()).setValue("accessToken", installation.getMarketAccessToken()).build());
            fileName = this.httpClient.download(request, uploadModulesFolder);
        }
        File projectBundleFile = Paths.get(uploadModulesFolder.toString(), fileName).toFile();
        if (!projectBundleFile.exists()) {
            return;
        }
        String actualVersion = projectVersion;
        if ("latest".equals(actualVersion)) {
            actualVersion = FileNameProxy.extractVersion((String)fileName);
        }
        try {
            this.unzipAndMoveModules(projectName, actualVersion, projectBundleFile);
            this.updateModuleManager(projectName, actualVersion);
        }
        finally {
            FolderProxy.clearFolder((File)uploadModulesFolder);
        }
    }

    private void updateModuleManager(String projectName, String projectVersion) {
        if (this.moduleManager.containsProject(projectName)) {
            this.moduleManager.setNewProjectVersion(projectName, projectVersion);
            this.moduleManager.loadNewProjectModules(projectName);
        }
        this.moduleManager.loadProjectModules(projectName);
    }

    private void unzipAndMoveModules(String projectName, String projectVersion, File projectBundleFile) throws Exception {
        this.unzipModulesFile(projectBundleFile);
        this.validateUnzippedModules(projectName);
        this.modulesBackupWriter.backup(projectName);
        this.doMoveModules(projectName, projectVersion);
    }

    private void validateUnzippedModules(String projectName) {
        File projectFolder = this.fileSystemManager.getUploadProjectFolder(projectName);
        File[] files = projectFolder.listFiles();
        if (files == null) {
            throw new ProjectInstallationException("The bundle did not contain project: " + projectName);
        }
        for (File file : files) {
            if (file.isFile()) {
                throw new ProjectInstallationException("The bundle contains unknown file: " + file.getName());
            }
            if (!AdminTargetManager.TARGET_FOLDERS.contains(file.getName())) {
                throw new ProjectInstallationException("The bundle contains unknown folder: " + file.getName());
            }
            this.validateUnzippedTargetFolder(projectName, file);
        }
    }

    private void validateUnzippedTargetFolder(String projectName, File targetFolder) {
        File[] files = targetFolder.listFiles();
        if (files == null) {
            throw new ProjectInstallationException("Folder: " + targetFolder + " is empty");
        }
        TargetType targetType = TargetType.of((String)targetFolder.getName());
        Set<String> containerFolders = this.moduleManager.getContainerFoldersByTarget(targetType);
        for (File file : files) {
            if (file.isFile()) {
                throw new ProjectInstallationException("Folder: " + targetFolder.getName() + " contains unknown file: " + file.getName());
            }
            if (!containerFolders.contains(file.getName())) {
                throw new ProjectInstallationException("Folder: " + targetFolder.getName() + " contains unknown folder: " + file.getName());
            }
            this.validateUnzippedModule(projectName, targetType, file);
        }
    }

    private void validateUnzippedModule(String projectName, TargetType targetType, File containerFolder) {
        File moduleFolder = Paths.get(containerFolder.toString(), projectName).toFile();
        if (!moduleFolder.exists()) {
            throw new ProjectInstallationException("Folder: " + targetType.getName() + "/" + containerFolder + " did not contain module: " + projectName);
        }
        File modulePropertiesFile = Paths.get(moduleFolder.toString(), "module.properties").toFile();
        if (!modulePropertiesFile.exists()) {
            throw new ProjectInstallationException("Module: " + targetType.getName() + "/" + containerFolder + "/" + projectName + " did not contain module: " + "module.properties" + " file");
        }
    }

    private void doMoveModules(String projectName, String projectVersion) {
        File projectFolder = this.fileSystemManager.getUploadProjectFolder(projectName);
        if (this.moduleManager.containsProject(projectName)) {
            this.copyNewModulesIfNotExists(projectName, projectFolder);
            this.platformFileManager.moveFilesToPlatformFolder(projectFolder);
            FolderProxy.writeDistinctLines((File)this.fileSystemManager.getNewEzyPlatformNewModulesFile(), (String)(projectName + "=" + projectVersion));
        } else {
            FolderProxy.copyFolder((File)projectFolder, (File)this.fileSystemManager.getEzyHomePath());
        }
    }

    private void copyNewModulesIfNotExists(String projectName, File projectFolder) {
        File ezyHomePath = this.fileSystemManager.getEzyHomePath();
        for (ModuleType moduleType : ModuleType.values()) {
            File existingModuleFolder = Paths.get(ezyHomePath.toString(), moduleType.getTargetFolder(), projectName).toFile();
            if (existingModuleFolder.exists()) continue;
            File newModuleFolder = Paths.get(projectFolder.toString(), moduleType.getTargetFolder(), projectName).toFile();
            if (!newModuleFolder.exists()) continue;
            FolderProxy.mkdirs((File)existingModuleFolder);
            FolderProxy.copyFolder((File)newModuleFolder, (File)existingModuleFolder);
        }
    }

    private void unzipModulesFile(File moduleFile) throws Exception {
        File rootFolder = this.fileSystemManager.concatWithEzyHome(Paths.get("upload/modules", new String[0]));
        ZipFileProxy.unzipFile((File)rootFolder, (File)moduleFile);
    }

    @Generated
    public AdminNewModulesWatcher(HttpClient httpClient, AdminProjectService projectService, AdminEnvironmentManager environmentManager, AdminFileSystemManager fileSystemManager, AdminMarketUrlManager marketUrlManager, AdminModuleManager moduleManager, AdminEzyPlatformFileManager platformFileManager, AdminEzyPlatformKeyManager platformKeyManager, AdminModulesBackupWriter modulesBackupWriter, AdminProjectInstallationQueue projectInstallationQueue) {
        this.httpClient = httpClient;
        this.projectService = projectService;
        this.environmentManager = environmentManager;
        this.fileSystemManager = fileSystemManager;
        this.marketUrlManager = marketUrlManager;
        this.moduleManager = moduleManager;
        this.platformFileManager = platformFileManager;
        this.platformKeyManager = platformKeyManager;
        this.modulesBackupWriter = modulesBackupWriter;
        this.projectInstallationQueue = projectInstallationQueue;
    }
}

