/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.validator;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyhttp.core.exception.HttpBadRequestException;
import java.util.HashMap;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.manager.AdminEzyPlatformKeyManager;
import org.youngmonkeys.ezyplatform.admin.service.AdminSettingService;

@EzySingleton
public class AdminMarketProxyValidator {
    private final AdminEzyPlatformKeyManager ezyPlatformKeyManager;
    private final AdminSettingService settingService;

    public void validateSsoPlatformKey(String platformKey) {
        HashMap<String, String> errors = new HashMap<String, String>();
        if (EzyStrings.isBlank((String)platformKey)) {
            errors.put("platformKey", "required");
        } else {
            String currentKey = this.ezyPlatformKeyManager.getPlatformKey();
            if (!platformKey.equals(currentKey)) {
                errors.put("platformKey", "invalid");
            }
        }
        if (errors.size() > 0) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validateSsoNonce(String nonce, long initializedTime) {
        HashMap<String, String> errors = new HashMap<String, String>();
        if (EzyStrings.isBlank((String)nonce)) {
            errors.put("nonce", "required");
        } else {
            String timeString;
            String decryptedNonce = this.settingService.decryptValue(nonce);
            if (!decryptedNonce.equals(timeString = String.valueOf(initializedTime))) {
                errors.put("nonce", "invalid");
            }
        }
        if (errors.size() > 0) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validateSsoCallbackUri(String callbackUri) {
        HashMap<String, String> errors = new HashMap<String, String>();
        if (EzyStrings.isBlank((String)callbackUri)) {
            errors.put("callbackUri", "required");
        } else if (callbackUri.startsWith("http://") || callbackUri.startsWith("https://") || !callbackUri.startsWith("/")) {
            errors.put("callbackUri", "invalid");
        }
        if (errors.size() > 0) {
            throw new HttpBadRequestException(errors);
        }
    }

    @Generated
    public AdminMarketProxyValidator(AdminEzyPlatformKeyManager ezyPlatformKeyManager, AdminSettingService settingService) {
        this.ezyPlatformKeyManager = ezyPlatformKeyManager;
        this.settingService = settingService;
    }
}

