/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.validator;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.security.EzyBase64;
import com.tvd12.ezyhttp.core.exception.HttpBadRequestException;
import com.tvd12.ezyhttp.core.exception.HttpNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.youngmonkeys.ezyplatform.admin.request.AddSettingRequest;
import org.youngmonkeys.ezyplatform.admin.request.AddWebLanguageRequest;
import org.youngmonkeys.ezyplatform.admin.request.ChangeAccessTokenEncryptionKeyRequest;
import org.youngmonkeys.ezyplatform.admin.request.ChangeEncryptionKeyRequest;
import org.youngmonkeys.ezyplatform.admin.request.SaveAccessTokenExpirationTimeRequest;
import org.youngmonkeys.ezyplatform.admin.request.SaveAdminLoginSettingsRequest;
import org.youngmonkeys.ezyplatform.admin.request.SaveRegularSettingsRequest;
import org.youngmonkeys.ezyplatform.admin.request.SaveWebsiteSettingsRequest;
import org.youngmonkeys.ezyplatform.admin.request.SettingsDecryptionRequest;
import org.youngmonkeys.ezyplatform.admin.request.SettingsEncryptionRequest;
import org.youngmonkeys.ezyplatform.admin.request.UpdateAdminUrlRequest;
import org.youngmonkeys.ezyplatform.admin.request.UpdatePropertiesRequest;
import org.youngmonkeys.ezyplatform.admin.request.UpdateSettingRequest;
import org.youngmonkeys.ezyplatform.admin.request.UpdateWebLanguageRequest;
import org.youngmonkeys.ezyplatform.admin.request.UpdateWebUrlsRequest;
import org.youngmonkeys.ezyplatform.admin.request.UpdateWebsocketUrlRequest;
import org.youngmonkeys.ezyplatform.admin.service.AdminLanguageService;
import org.youngmonkeys.ezyplatform.admin.service.AdminSettingService;
import org.youngmonkeys.ezyplatform.constant.ScheduleType;
import org.youngmonkeys.ezyplatform.entity.DataType;
import org.youngmonkeys.ezyplatform.model.WebLanguageModel;
import org.youngmonkeys.ezyplatform.validator.DefaultValidator;

@EzySingleton
public class AdminSettingsValidator {
    private final AdminSettingService settingService;
    private final AdminLanguageService adminLanguageService;
    private final Map<DataType, Function<String, Boolean>> settingValueValidators;

    public AdminSettingsValidator(ObjectMapper objectMapper, AdminSettingService settingService, AdminLanguageService adminLanguageService) {
        this.settingService = settingService;
        this.adminLanguageService = adminLanguageService;
        this.settingValueValidators = new HashMap<DataType, Function<String, Boolean>>();
        this.settingValueValidators.put(DataType.BOOLEAN, DefaultValidator::isBoolean);
        this.settingValueValidators.put(DataType.EMAIL, DefaultValidator::isValidEmail);
        this.settingValueValidators.put(DataType.FLOAT, DefaultValidator::isFloatNumber);
        this.settingValueValidators.put(DataType.INTEGER, DefaultValidator::isIntegerNumber);
        this.settingValueValidators.put(DataType.JSON, value -> {
            try {
                objectMapper.readTree(value);
                return true;
            }
            catch (IOException e) {
                return false;
            }
        });
        this.settingValueValidators.put(DataType.LONG, DefaultValidator::isIntegerNumber);
        this.settingValueValidators.put(DataType.URL, DefaultValidator::isValidUrl);
    }

    public void validate(SaveRegularSettingsRequest request) {
        ScheduleType newPlatformMailScheduleType = request.getNewPlatformMailScheduleType();
        HashMap<String, String> errors = new HashMap<String, String>();
        String defaultLanguageCode = request.getDefaultAdminLanguage();
        if (EzyStrings.isNotBlank((String)defaultLanguageCode) && !this.adminLanguageService.containsLanguage(defaultLanguageCode)) {
            errors.put("defaultAdminLanguage", "invalid");
        }
        if (newPlatformMailScheduleType == null) {
            errors.put("newPlatformMailScheduleType", "required");
        } else if (newPlatformMailScheduleType != ScheduleType.DAYS && newPlatformMailScheduleType != ScheduleType.WEEKS && newPlatformMailScheduleType != ScheduleType.MONTHS && newPlatformMailScheduleType != ScheduleType.NEVER) {
            errors.put("newPlatformMailScheduleType", "invalid");
        }
        int numberOfMediaPerPage = request.getNumberOfMediaPerPage();
        if (numberOfMediaPerPage == 0) {
            errors.put("numberOfMediaPerPage", "required");
        } else if (numberOfMediaPerPage < 0) {
            errors.put("numberOfMediaPerPage", "invalid");
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(SaveAdminLoginSettingsRequest request) {
        HashMap<String, String> errors = new HashMap<String, String>();
        Integer maxLoginFailures = request.getMaxLoginFailures();
        Integer loginFailureBlockDuration = request.getLoginFailureBlockDuration();
        if (maxLoginFailures != null) {
            if (maxLoginFailures <= 0) {
                errors.put("maxLoginFailures", "invalid");
            }
            if (loginFailureBlockDuration == null) {
                errors.put("loginFailureBlockDuration", "required");
            }
        }
        if (loginFailureBlockDuration != null && loginFailureBlockDuration <= 0) {
            errors.put("loginFailureBlockDuration", "invalid");
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(SaveWebsiteSettingsRequest request) {
        String websiteTagLine;
        String pageTitleSeparator;
        HashMap<String, String> errors = new HashMap<String, String>();
        String websiteTitle = request.getWebsiteTitle();
        if (EzyStrings.isNotBlank((String)websiteTitle) && websiteTitle.length() > 60) {
            errors.put("websiteTitle", "overLength");
        }
        if (EzyStrings.isNotBlank((String)(pageTitleSeparator = request.getPageTitleSeparator())) && pageTitleSeparator.length() > 12) {
            errors.put("pageTitleSeparator", "overLength");
        }
        if (EzyStrings.isNotBlank((String)(websiteTagLine = request.getWebsiteTagLine())) && websiteTagLine.length() > 120) {
            errors.put("websiteTagLine", "overLength");
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(AddSettingRequest request) {
        HashMap<String, String> errors = new HashMap<String, String>();
        if (EzyStrings.isBlank((String)request.getName())) {
            errors.put("addSettingName", "required");
        } else if (this.settingService.containSetting(request.getName())) {
            errors.put("addSettingName", "duplicated");
        }
        if (request.getDataType() == null) {
            errors.put("addSettingDataType", "required");
        }
        if (EzyStrings.isBlank((String)request.getValue())) {
            errors.put("addSettingValue", "required");
        } else if (this.isInvalidSettingValue(request.getDataType(), request.getValue())) {
            errors.put("addSettingValue", "invalid");
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(UpdateSettingRequest request) {
        HashMap<String, String> errors = new HashMap<String, String>();
        if (EzyStrings.isBlank((String)request.getName())) {
            errors.put("editSettingName", "required");
        }
        if (request.getDataType() == null) {
            errors.put("editSettingDataType", "required");
        }
        if (EzyStrings.isBlank((String)request.getValue())) {
            errors.put("editSettingValue", "required");
        } else if (this.isInvalidSettingValue(request.getDataType(), request.getValue())) {
            errors.put("editSettingValue", "invalid");
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(UpdateAdminUrlRequest request) {
        HashMap<String, String> errors = new HashMap<String, String>();
        if (EzyStrings.isBlank((String)request.getAdminUrl())) {
            errors.put("adminUrl", "required");
        } else if (!DefaultValidator.isValidHttpUrl((String)request.getAdminUrl())) {
            errors.put("adminUrl", "invalid");
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(UpdateWebUrlsRequest request) {
        HashMap<String, String> errors = new HashMap<String, String>();
        if (EzyStrings.isBlank((String)request.getWebUrl())) {
            errors.put("webUrl", "required");
        } else if (!DefaultValidator.isValidHttpUrl((String)request.getWebUrl())) {
            errors.put("webUrl", "invalid");
        }
        if (EzyStrings.isBlank((String)request.getWebManagementUrl())) {
            errors.put("webManagementUrl", "required");
        } else if (!DefaultValidator.isValidHttpUrl((String)request.getWebUrl())) {
            errors.put("webManagementUrl", "invalid");
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(UpdateWebsocketUrlRequest request) {
        HashMap<String, String> errors = new HashMap<String, String>();
        if (EzyStrings.isBlank((String)request.getWebsocketUrl())) {
            errors.put("websocketUrl", "required");
        } else if (!DefaultValidator.isValidWebsocketUrl((String)request.getWebsocketUrl())) {
            errors.put("websocketUrl", "invalid");
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(UpdatePropertiesRequest request, boolean allowsEmpty) {
        HashMap<String, String> errors = new HashMap<String, String>();
        if (!allowsEmpty && request.getProperties().isEmpty()) {
            errors.put("properties", "required");
        }
        for (String propertyName : request.getProperties().keySet()) {
            if (propertyName.matches("[\\d\\w_\\-\\.\\+\\$]+")) continue;
            errors.put("properties", "invalid");
            break;
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(ChangeEncryptionKeyRequest request) {
        HashMap<String, String> errors = new HashMap<String, String>();
        if (EzyStrings.isBlank((String)request.getNewEncryptionKey())) {
            errors.put("newEncryptionKey", "required");
        } else if (!request.getNewEncryptionKey().matches("[a-zA-Z0-9]{32}")) {
            errors.put("newEncryptionKey", "invalid");
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(SettingsEncryptionRequest request) {
        HashMap<String, String> errors = new HashMap<String, String>();
        if (EzyStrings.isBlank((String)request.getEncryptionClearText())) {
            errors.put("encryptionClearText", "required");
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(SettingsDecryptionRequest request) {
        HashMap<String, String> errors = new HashMap<String, String>();
        if (EzyStrings.isBlank((String)request.getDecryptionEncryptedText())) {
            errors.put("decryptionEncryptedText", "required");
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(Map<String, WebLanguageModel> languageModelMap, AddWebLanguageRequest request) {
        HashMap<String, String> errors = new HashMap<String, String>();
        this.validate("add", errors, request.getAddWebLanguageName(), request.getAddWebLanguageFlag());
        String code = request.getAddWebLanguageCode();
        if (EzyStrings.isBlank((String)code)) {
            errors.put("addWebLanguageCode", "required");
        } else if (code.length() > 25) {
            errors.put("addWebLanguageCode", "invalid");
        } else if (languageModelMap.containsKey(request.getAddWebLanguageCode())) {
            errors.put("addWebLanguageCode", "duplicated");
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(Map<String, WebLanguageModel> languageModelMap, String languageCode, UpdateWebLanguageRequest request) {
        if (!languageModelMap.containsKey(languageCode)) {
            throw new HttpNotFoundException(Collections.singletonMap("webLanguage", "notFound"));
        }
        HashMap<String, String> errors = new HashMap<String, String>();
        this.validate("edit", errors, request.getEditWebLanguageName(), request.getEditWebLanguageFlag());
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    private void validate(String action, Map<String, String> errors, String name, String flag) {
        if (EzyStrings.isBlank((String)name)) {
            errors.put(action + "WebLanguageName", "required");
        } else if (name.length() > 50) {
            errors.put(action + "WebLanguageName", "invalid");
        }
        if (EzyStrings.isBlank((String)flag)) {
            errors.put(action + "WebLanguageFlag", "required");
        } else if (flag.length() > 30) {
            errors.put(action + "WebLanguageFlag", "invalid");
        }
    }

    public void validate(ChangeAccessTokenEncryptionKeyRequest request) {
        HashMap<String, String> errors = new HashMap<String, String>();
        String encryptionKey = request.getNewEncryptionKey();
        if (EzyStrings.isBlank((String)encryptionKey)) {
            errors.put("newEncryptionKey", "required");
        } else {
            try {
                byte[] encryptionKeyBytes = EzyBase64.decode((String)encryptionKey);
                if (encryptionKeyBytes.length != 32) {
                    errors.put("newEncryptionKey", "invalid");
                }
            }
            catch (Exception e) {
                errors.put("newEncryptionKey", "invalid");
            }
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(SaveAccessTokenExpirationTimeRequest request) {
        HashMap<String, String> errors = new HashMap<String, String>();
        long tokenExpiredTimeInDay = request.getTokenExpiredTimeInDay();
        if (tokenExpiredTimeInDay == 0L) {
            errors.put("tokenExpiredTimeInDay", "required");
        } else if (tokenExpiredTimeInDay < 0L) {
            errors.put("tokenExpiredTimeInDay", "invalid");
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    private boolean isInvalidSettingValue(DataType dataType, String value) {
        Function<String, Boolean> validator = this.settingValueValidators.get(dataType);
        boolean valid = validator != null ? validator.apply(value) : true;
        return !valid;
    }
}

