/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.nio.websocket;

import com.tvd12.ezyfox.callback.EzyCallback;
import com.tvd12.ezyfox.codec.EzyMessageHeaderReader;
import com.tvd12.ezyfox.codec.EzySimpleStringDataDecoder;
import com.tvd12.ezyfox.codec.EzyStringDataDecoder;
import com.tvd12.ezyfox.codec.EzyStringToObjectDecoder;
import com.tvd12.ezyfox.io.EzyBytes;
import com.tvd12.ezyfoxserver.entity.EzySession;
import com.tvd12.ezyfoxserver.nio.handler.EzyAbstractHandlerGroup;
import com.tvd12.ezyfoxserver.nio.websocket.EzyWsHandlerGroup;
import com.tvd12.ezyfoxserver.socket.EzySimpleSocketStream;
import com.tvd12.ezyfoxserver.socket.EzySocketStream;

public class EzySimpleWsHandlerGroup
extends EzyAbstractHandlerGroup<EzyStringDataDecoder>
implements EzyWsHandlerGroup {
    private final EzyCallback<Object> decodeBytesCallback = this.newDecodeBytesCallback();

    public EzySimpleWsHandlerGroup(Builder builder) {
        super(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    protected EzyCallback<Object> newDecodeBytesCallback() {
        return new EzyCallback<Object>(){

            public void call(Object data) {
                throw new UnsupportedOperationException("should use call(data, dataSize)");
            }

            public void call(Object data, int dataSize) {
                EzySimpleWsHandlerGroup.this.handleReceivedData(data, dataSize);
            }
        };
    }

    @Override
    protected EzyStringDataDecoder newDecoder(Object decoder) {
        return new EzySimpleStringDataDecoder((EzyStringToObjectDecoder)decoder);
    }

    @Override
    public void fireBytesReceived(String bytes) {
        this.handleReceivedBytes(bytes);
        this.executeAddReadBytes(bytes.length());
    }

    @Override
    public void fireBytesReceived(byte[] bytes, int offset, int len) {
        this.handleReceivedBytes(bytes, offset, len);
        this.executeAddReadBytes(len - offset);
    }

    private void executeHandleReceivedBytes(String bytes) {
        this.handleReceivedBytes(bytes);
    }

    private void executeHandleReceivedBytes(byte[] bytes) {
        this.handleReceivedBytes(bytes);
    }

    private void handleReceivedBytes(String bytes) {
        try {
            ((EzyStringDataDecoder)this.decoder).decode(bytes, this.decodeBytesCallback);
        }
        catch (Throwable throwable) {
            this.fireExceptionCaught(throwable);
        }
    }

    private void handleReceivedBytes(byte[] bytes) {
        try {
            ((EzyStringDataDecoder)this.decoder).decode(bytes, this.decodeBytesCallback);
        }
        catch (Throwable throwable) {
            this.fireExceptionCaught(throwable);
        }
    }

    private void handleReceivedBytes(byte[] bytes, int offset, int len) {
        try {
            if (len <= 1) {
                return;
            }
            byte headerByte = bytes[offset];
            boolean isRawBytes = EzyMessageHeaderReader.readRawBytes((byte)headerByte);
            if (isRawBytes) {
                boolean sessionStreamingEnable = this.session.isStreamingEnable();
                if (!this.streamingEnable || !sessionStreamingEnable) {
                    return;
                }
                byte[] rawBytes = EzyBytes.copy((byte[])bytes, (int)offset, (int)len);
                EzySimpleSocketStream stream = new EzySimpleSocketStream((EzySession)this.session, rawBytes);
                this.streamQueue.add((EzySocketStream)stream);
            } else {
                int newLen = len - 1;
                int newOffset = offset + 1;
                byte[] messageBytes = EzyBytes.copy((byte[])bytes, (int)newOffset, (int)newLen);
                this.handleReceivedBytes(messageBytes);
            }
        }
        catch (Throwable throwable) {
            this.fireExceptionCaught(throwable);
        }
    }

    public static class Builder
    extends EzyAbstractHandlerGroup.Builder {
        public EzyWsHandlerGroup build() {
            return new EzySimpleWsHandlerGroup(this);
        }
    }
}

