/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.security;

import com.tvd12.ezyfox.io.EzyPrints;
import com.tvd12.ezyfox.security.EzyMessageDigests;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;

public final class EzySHA256 {
    public static final String ALGORITHM = "SHA-256";

    private EzySHA256() {
    }

    public static String cryptUtf(String originalString) {
        byte[] bytes = originalString.getBytes(StandardCharsets.UTF_8);
        return EzySHA256.cryptUtf(bytes);
    }

    public static String cryptUtf(byte[] bytes) {
        byte[] encodedHash = EzySHA256.cryptUtfToBytes(bytes);
        return EzyPrints.printHex((byte[])encodedHash);
    }

    public static String cryptUtfToLowercase(String originalString) {
        byte[] bytes = originalString.getBytes(StandardCharsets.UTF_8);
        return EzySHA256.cryptUtfToLowercase(bytes);
    }

    public static String cryptUtfToLowercase(byte[] bytes) {
        byte[] encodedHash = EzySHA256.cryptUtfToBytes(bytes);
        return EzyPrints.printHexLowercase((byte[])encodedHash);
    }

    public static byte[] cryptUtfToBytes(String originalString) {
        byte[] bytes = originalString.getBytes(StandardCharsets.UTF_8);
        return EzySHA256.cryptUtfToBytes(bytes);
    }

    public static byte[] cryptUtfToBytes(byte[] bytes) {
        MessageDigest digest = EzyMessageDigests.getAlgorithm(ALGORITHM);
        return digest.digest(bytes);
    }
}

