/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.nio;

import com.tvd12.ezyfox.util.EzyProcessor;
import com.tvd12.ezyfoxserver.nio.EzyAbstractSocketServerBootstrap;
import com.tvd12.ezyfoxserver.nio.socket.EzyNioAcceptableConnectionsHandler;
import com.tvd12.ezyfoxserver.nio.socket.EzyNioSecureSocketAcceptor;
import com.tvd12.ezyfoxserver.nio.socket.EzyNioSocketAcceptanceLoopHandler;
import com.tvd12.ezyfoxserver.nio.socket.EzyNioSocketAcceptor;
import com.tvd12.ezyfoxserver.nio.socket.EzyNioSocketReader;
import com.tvd12.ezyfoxserver.nio.socket.EzyNioSocketReadingLoopHandler;
import com.tvd12.ezyfoxserver.nio.socket.EzyNioSocketWriter;
import com.tvd12.ezyfoxserver.setting.EzySocketSetting;
import com.tvd12.ezyfoxserver.socket.EzySocketEventHandler;
import com.tvd12.ezyfoxserver.socket.EzySocketEventLoopHandler;
import com.tvd12.ezyfoxserver.socket.EzySocketWritingLoopHandler;
import com.tvd12.ezyfoxserver.ssl.EzySslContextProxy;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;

public class EzySocketServerBootstrap
extends EzyAbstractSocketServerBootstrap {
    private Selector readSelector;
    private Selector acceptSelector;
    private ServerSocket serverSocket;
    private ServerSocketChannel serverSocketChannel;
    private EzySocketEventLoopHandler readingLoopHandler;
    private EzySocketEventLoopHandler socketAcceptanceLoopHandler;
    private final EzySslContextProxy sslContextProxy;
    private final EzySocketSetting socketSetting;

    public EzySocketServerBootstrap(Builder builder) {
        super(builder);
        this.sslContextProxy = builder.sslContextProxy;
        this.socketSetting = this.serverSettings.getSocket();
    }

    public static Builder builder() {
        return new Builder();
    }

    public void start() throws Exception {
        this.openSelectors();
        this.newAndConfigServerSocketChannel();
        this.getBindAndConfigServerSocket();
        this.startSocketHandlers();
    }

    @Override
    public void destroy() {
        EzyProcessor.processWithLogException(() -> this.writingLoopHandler.destroy());
        EzyProcessor.processWithLogException(() -> this.readingLoopHandler.destroy());
        EzyProcessor.processWithLogException(() -> this.socketAcceptanceLoopHandler.destroy());
        EzyProcessor.processWithLogException(() -> this.serverSocket.close());
        EzyProcessor.processWithLogException(() -> this.serverSocketChannel.close());
    }

    private void openSelectors() throws Exception {
        this.readSelector = this.openSelector();
        this.acceptSelector = this.openSelector();
    }

    private void newAndConfigServerSocketChannel() throws Exception {
        this.serverSocketChannel = this.newServerSocketChannel();
        this.serverSocketChannel.configureBlocking(false);
    }

    private void getBindAndConfigServerSocket() throws Exception {
        this.serverSocket = this.serverSocketChannel.socket();
        this.serverSocket.setReuseAddress(true);
        this.serverSocket.bind(new InetSocketAddress(this.socketSetting.getAddress(), this.socketSetting.getPort()));
        this.serverSocketChannel.register(this.acceptSelector, 16);
    }

    private void startSocketHandlers() throws Exception {
        EzyNioSocketAcceptor socketAcceptor = this.newSocketAcceptor();
        this.writingLoopHandler = this.newWritingLoopHandler();
        this.readingLoopHandler = this.newReadingLoopHandler(socketAcceptor);
        this.socketAcceptanceLoopHandler = this.newSocketAcceptanceLoopHandler(socketAcceptor);
        this.socketAcceptanceLoopHandler.start();
        this.readingLoopHandler.start();
        this.writingLoopHandler.start();
    }

    private EzyNioSocketAcceptor newSocketAcceptor() {
        return this.socketSetting.isCertificationSslActive() ? new EzyNioSecureSocketAcceptor(this.sslContextProxy, this.socketSetting.getSslHandshakeTimeout(), this.socketSetting.getMaxRequestSize()) : new EzyNioSocketAcceptor();
    }

    private EzySocketEventLoopHandler newWritingLoopHandler() {
        EzySocketWritingLoopHandler loopHandler = new EzySocketWritingLoopHandler();
        loopHandler.setThreadPoolSize(this.socketSetting.getWriterThreadPoolSize());
        loopHandler.setEventHandlerSupplier(() -> {
            EzyNioSocketWriter eventHandler = new EzyNioSocketWriter();
            eventHandler.setWriterGroupFetcher(this.handlerGroupManager);
            eventHandler.setSessionTicketsQueue(this.sessionTicketsQueue);
            return eventHandler;
        });
        return loopHandler;
    }

    private EzySocketEventLoopHandler newReadingLoopHandler(EzyNioAcceptableConnectionsHandler acceptableConnectionsHandler) {
        EzyNioSocketReadingLoopHandler loopHandler = new EzyNioSocketReadingLoopHandler();
        loopHandler.setThreadPoolSize(this.getSocketReaderThreadPoolSize());
        EzyNioSocketReader eventHandler = new EzyNioSocketReader();
        eventHandler.setOwnSelector(this.readSelector);
        eventHandler.setSocketDataReceiver(this.socketDataReceiver);
        eventHandler.setAcceptableConnectionsHandler(acceptableConnectionsHandler);
        loopHandler.setEventHandler((EzySocketEventHandler)eventHandler);
        return loopHandler;
    }

    private EzySocketEventLoopHandler newSocketAcceptanceLoopHandler(EzyNioSocketAcceptor socketAcceptor) {
        EzyNioSocketAcceptanceLoopHandler loopHandler = new EzyNioSocketAcceptanceLoopHandler();
        loopHandler.setThreadPoolSize(this.getSocketAcceptorThreadPoolSize());
        socketAcceptor.setTcpNoDelay(this.socketSetting.isTcpNoDelay());
        socketAcceptor.setReadSelector(this.readSelector);
        socketAcceptor.setOwnSelector(this.acceptSelector);
        socketAcceptor.setHandlerGroupManager(this.handlerGroupManager);
        loopHandler.setEventHandler((EzySocketEventHandler)socketAcceptor);
        return loopHandler;
    }

    private Selector openSelector() throws Exception {
        return Selector.open();
    }

    private ServerSocketChannel newServerSocketChannel() throws Exception {
        return ServerSocketChannel.open();
    }

    private int getSocketReaderThreadPoolSize() {
        return 1;
    }

    private int getSocketAcceptorThreadPoolSize() {
        return 1;
    }

    public static class Builder
    extends EzyAbstractSocketServerBootstrap.Builder<Builder, EzySocketServerBootstrap> {
        private EzySslContextProxy sslContextProxy;

        public Builder sslContextProxy(EzySslContextProxy sslContextProxy) {
            this.sslContextProxy = sslContextProxy;
            return this;
        }

        public EzySocketServerBootstrap build() {
            return new EzySocketServerBootstrap(this);
        }
    }
}

