/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.cli.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.youngmonkeys.ezyplatform.cli.constant.CliConstants;
import org.youngmonkeys.ezyplatform.entity.TargetType;

public final class CliFolderProxy {
    private CliFolderProxy() {
    }

    public static void createFileIfNotExists(File file) throws IOException {
        if (!file.exists()) {
            File parentFile = file.getParentFile();
            if (parentFile != null && !parentFile.exists()) {
                Files.createDirectories(parentFile.toPath(), new FileAttribute[0]);
            }
            Files.createFile(file.toPath(), new FileAttribute[0]);
        }
    }

    public static File getTargetInfoFile(TargetType targetType) {
        Path runtimeFolder = Paths.get(".runtime", new String[0]);
        return Paths.get(runtimeFolder.toString(), targetType.getName(), "info.txt").toFile();
    }

    public static File getModuleMetadataFileByTarget(String target, String metadataFileName) {
        return Paths.get(".runtime", target, metadataFileName + ".txt").toFile();
    }

    public static File[] getContainerFoldersByTarget(String target) {
        File pluginsFolder = Paths.get(target, "plugins").toFile();
        if (target.equals("admin")) {
            return new File[]{pluginsFolder};
        }
        if (target.equals("web")) {
            return new File[]{pluginsFolder, Paths.get(target, "themes").toFile()};
        }
        return new File[]{pluginsFolder, Paths.get(target, "apps").toFile()};
    }

    public static boolean containsModule(String moduleType, String moduleName) {
        Path folder = Paths.get(CliConstants.MODULE_PARENT_FOLDERS.get(moduleType), CliConstants.MODULE_CONTAINER_FOLDERS.get(moduleType));
        return CliFolderProxy.containFileOrFolder(folder.toFile(), moduleName);
    }

    public static boolean containFileOrFolder(File folder, String itemName) {
        for (File file : CliFolderProxy.listFiles(folder)) {
            if (!file.getName().equals(itemName)) continue;
            return true;
        }
        return false;
    }

    public static File[] listFiles(File folder) {
        File[] files = null;
        if (folder.exists()) {
            files = folder.listFiles();
        }
        return files != null ? files : new File[]{};
    }

    public static File getContainerFolderByModuleType(String moduleType) {
        return Paths.get(CliConstants.MODULE_PARENT_FOLDERS.get(moduleType), CliConstants.MODULE_CONTAINER_FOLDERS.get(moduleType)).toFile();
    }

    public static File getModuleFolder(String moduleType, String moduleName) {
        return Paths.get(CliFolderProxy.getContainerFolderByModuleType(moduleType).toString(), moduleName).toFile();
    }

    public static File getModuleMetadataFileByModuleType(String moduleType) {
        return CliFolderProxy.getModuleMetadataFileByTarget(CliConstants.MODULE_PARENT_FOLDERS.get(moduleType), CliConstants.MODULE_CONTAINER_FOLDERS.get(moduleType));
    }

    public static List<String> getModuleNamesByModuleType(String moduleType) {
        File containerFolder = CliFolderProxy.getContainerFolderByModuleType(moduleType);
        File[] moduleFolders = CliFolderProxy.listFiles(containerFolder);
        return Stream.of(moduleFolders).filter(it -> !it.isHidden()).filter(File::isDirectory).map(File::getName).collect(Collectors.toList());
    }

    public static Map<String, List<String>> getModuleNamesMapByModuleTypes(List<String> moduleTypes) {
        return moduleTypes.stream().collect(Collectors.toMap(it -> it, CliFolderProxy::getModuleNamesByModuleType));
    }
}

