/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.stream;

import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.stream.EzyInputStreamReader;
import com.tvd12.ezyfox.stream.EzyInputStreams;
import com.tvd12.ezyfox.util.EzyReturner;
import java.io.InputStream;
import java.util.List;

public class EzySimpleInputStreamReader
implements EzyInputStreamReader {
    @Override
    public byte[] readBytes(InputStream stream) {
        try {
            return EzyInputStreams.toByteArray(stream);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public String readString(InputStream stream, String charset) {
        return (String)EzyReturner.returnWithIllegalArgumentException(() -> new String(this.readBytes(stream), charset));
    }

    @Override
    public char[] readChars(InputStream stream, String charset) {
        return this.readString(stream, charset).toCharArray();
    }

    @Override
    public List<String> readLines(InputStream stream, String charset) {
        try {
            return EzyInputStreams.toLines(stream, charset);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements EzyBuilder<EzyInputStreamReader> {
        public EzyInputStreamReader build() {
            return new EzySimpleInputStreamReader();
        }
    }
}

