/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.nio;

import com.tvd12.ezyfox.util.EzyProcessor;
import com.tvd12.ezyfoxserver.nio.EzyAbstractSocketServerBootstrap;
import com.tvd12.ezyfoxserver.nio.builder.impl.EzyWebSocketSecureServerCreator;
import com.tvd12.ezyfoxserver.nio.builder.impl.EzyWebSocketServerCreator;
import com.tvd12.ezyfoxserver.nio.websocket.EzyWsWritingLoopHandler;
import com.tvd12.ezyfoxserver.nio.wrapper.EzyNioSessionManager;
import com.tvd12.ezyfoxserver.setting.EzyWebSocketSetting;
import com.tvd12.ezyfoxserver.socket.EzySocketEventLoopHandler;
import com.tvd12.ezyfoxserver.socket.EzySocketWriter;
import com.tvd12.ezyfoxserver.socket.EzySocketWriterGroupFetcher;
import com.tvd12.ezyfoxserver.ssl.EzySslContextProxy;
import org.eclipse.jetty.server.Server;

public class EzyWebSocketServerBootstrap
extends EzyAbstractSocketServerBootstrap {
    private Server websocketServer;
    private final EzySslContextProxy sslContextProxy;
    private final EzyWebSocketSetting webSocketSetting;

    public EzyWebSocketServerBootstrap(Builder builder) {
        super(builder);
        this.sslContextProxy = builder.sslContextProxy;
        this.webSocketSetting = this.serverSettings.getWebsocket();
    }

    public static Builder builder() {
        return new Builder();
    }

    public void start() throws Exception {
        this.websocketServer = this.newWebsocketServer();
        this.websocketServer.start();
        this.writingLoopHandler = this.newWritingLoopHandler();
        this.writingLoopHandler.start();
    }

    @Override
    public void destroy() {
        EzyProcessor.processWithLogException(() -> this.writingLoopHandler.destroy());
        EzyProcessor.processWithLogException(() -> this.websocketServer.stop());
    }

    private Server newWebsocketServer() {
        return this.newSocketServerCreator().setting(this.webSocketSetting).sessionManagementSetting(this.serverSettings.getSessionManagement()).sessionManager((EzyNioSessionManager)this.server.getSessionManager()).handlerGroupManager(this.handlerGroupManager).socketDataReceiver(this.socketDataReceiver).create();
    }

    private EzySocketEventLoopHandler newWritingLoopHandler() {
        EzyWsWritingLoopHandler loopHandler = new EzyWsWritingLoopHandler();
        loopHandler.setThreadPoolSize(this.webSocketSetting.getWriterThreadPoolSize());
        loopHandler.setEventHandlerSupplier(() -> {
            EzySocketWriter eventHandler = new EzySocketWriter();
            eventHandler.setWriterGroupFetcher((EzySocketWriterGroupFetcher)this.handlerGroupManager);
            eventHandler.setSessionTicketsQueue(this.sessionTicketsQueue);
            return eventHandler;
        });
        return loopHandler;
    }

    private EzyWebSocketServerCreator newSocketServerCreator() {
        if (this.webSocketSetting.isSslActive()) {
            return new EzyWebSocketSecureServerCreator(this.sslContextProxy);
        }
        return new EzyWebSocketServerCreator();
    }

    public static class Builder
    extends EzyAbstractSocketServerBootstrap.Builder<Builder, EzyWebSocketServerBootstrap> {
        private EzySslContextProxy sslContextProxy;

        public Builder sslContextProxy(EzySslContextProxy sslContextProxy) {
            this.sslContextProxy = sslContextProxy;
            return this;
        }

        public EzyWebSocketServerBootstrap build() {
            return new EzyWebSocketServerBootstrap(this);
        }
    }
}

