/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.util;

import com.tvd12.ezyfox.util.EzyArrayUtil;
import com.tvd12.ezyfox.util.EzyFileUtil;
import com.tvd12.ezyfox.util.EzyFolderTreePrinter;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Stack;
import java.util.function.Consumer;

public class EzyDirectories {
    private File directory;

    public static void deleteFolder(File folder) throws IOException {
        EzyDirectories.deleteFolder(folder, it -> {});
    }

    public static void deleteFolder(File folder, Consumer<File> callback) throws IOException {
        Stack<File> stack = new Stack<File>();
        stack.push(folder);
        while (stack.size() > 0) {
            File parent = (File)stack.pop();
            File[] fileList = parent.listFiles();
            if (EzyArrayUtil.isEmpty(fileList)) {
                Files.deleteIfExists(parent.toPath());
                callback.accept(parent);
                continue;
            }
            stack.push(parent);
            for (File child : fileList) {
                if (child.isDirectory()) {
                    stack.push(child);
                    continue;
                }
                Files.delete(child.toPath());
                callback.accept(child);
            }
        }
    }

    public static void copyFolder(File from, File to) throws IOException {
        EzyDirectories.copyFolder(from, to, it -> {});
    }

    public static void copyFolder(File from, File to, Consumer<File> callback) throws IOException {
        if (!from.exists()) {
            return;
        }
        Stack<File> stack = new Stack<File>();
        stack.push(from);
        while (stack.size() > 0) {
            File parent = (File)stack.pop();
            File[] fileList = parent.listFiles();
            if (EzyArrayUtil.isEmpty(fileList)) continue;
            for (File child : fileList) {
                if (child.isDirectory()) {
                    stack.push(child);
                    continue;
                }
                File toFile = Paths.get(to.toString(), EzyDirectories.subpath(child, from).toString()).toFile();
                EzyFileUtil.copyFile(child, toFile);
                callback.accept(child);
            }
        }
    }

    public static File subpath(File fullPath, File rootPath) {
        return EzyDirectories.subpath(fullPath.toPath(), rootPath.toPath()).toFile();
    }

    public static Path subpath(Path fullPath, Path rootPath) {
        return fullPath.subpath(rootPath.getNameCount(), fullPath.getNameCount());
    }

    public URL[] getURLs() throws IOException {
        return this.getURLs(this.getFiles());
    }

    public URL[] getURLs(String[] extensions) throws IOException {
        return this.getURLs(extensions, true);
    }

    public URL[] getURLs(String[] extensions, boolean recursive) throws IOException {
        return this.getURLs(this.getFiles(extensions, recursive));
    }

    private URL[] getURLs(Collection<File> files) throws IOException {
        int index = 0;
        URL[] urls = new URL[files.size()];
        for (File file : files) {
            urls[index++] = file.toURI().toURL();
        }
        return urls;
    }

    public Collection<File> getFiles() {
        return EzyFileUtil.listFiles(this.directory, true);
    }

    public Collection<File> getFiles(String[] extensions) {
        return this.getFiles(extensions, true);
    }

    public Collection<File> getFiles(String[] extensions, boolean recursive) {
        return EzyFileUtil.listFiles(this.directory, extensions, recursive);
    }

    public String printTree(boolean printFile) {
        return EzyFolderTreePrinter.builder().printFile(printFile).build().print(this.directory);
    }

    public EzyDirectories directory(File directory) {
        this.directory = directory;
        return this;
    }

    public EzyDirectories directory(String directoryPath) {
        return this.directory(new File(directoryPath));
    }

    public String toString() {
        return this.directory.toString();
    }
}

