/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.pagination;

import com.tvd12.ezydata.database.query.EzyQueryConditionBuilder;
import com.tvd12.ezyfox.builder.EzyBuilder;
import java.util.Collection;
import org.youngmonkeys.ezyplatform.pagination.UserFilter;

public class DefaultUserFilter
implements UserFilter {
    public final String status;
    public final Collection<String> statuses;
    public final String uniqueKeyword;
    public final String likeKeyword;
    public final Collection<String> keywords;
    public final Long roleId;
    public final Collection<Long> roleIds;
    public final String roleName;
    public final Collection<String> roleNames;
    public final Long exclusiveRoleId;
    public final Collection<Long> exclusiveRoleIds;
    public final String exclusiveRoleName;
    public final Collection<String> exclusiveRoleNames;

    protected DefaultUserFilter(Builder<?> builder) {
        this.status = ((Builder)builder).status;
        this.statuses = ((Builder)builder).statuses;
        this.uniqueKeyword = ((Builder)builder).uniqueKeyword;
        this.likeKeyword = ((Builder)builder).likeKeyword;
        this.keywords = ((Builder)builder).keywords;
        this.roleId = ((Builder)builder).roleId;
        this.roleIds = ((Builder)builder).roleIds;
        this.roleName = ((Builder)builder).roleName;
        this.roleNames = ((Builder)builder).roleNames;
        this.exclusiveRoleId = ((Builder)builder).exclusiveRoleId;
        this.exclusiveRoleIds = ((Builder)builder).exclusiveRoleIds;
        this.exclusiveRoleName = ((Builder)builder).exclusiveRoleName;
        this.exclusiveRoleNames = ((Builder)builder).exclusiveRoleNames;
    }

    public void decorateQueryStringBeforeWhere(StringBuilder queryString) {
        if (this.keywords != null) {
            queryString.append(" INNER JOIN UserKeyword k ON e.id = k.userId");
        }
        if (this.roleId != null || this.roleIds != null || this.roleName != null || this.roleNames != null) {
            queryString.append(" INNER JOIN UserRole l ON e.id = l.userId");
            if (this.roleName != null || this.roleNames != null) {
                queryString.append(" INNER JOIN UserRoleName m ON m.id = l.roleId");
            }
        }
        if (this.exclusiveRoleId != null || this.exclusiveRoleName != null || this.exclusiveRoleIds != null || this.exclusiveRoleNames != null) {
            queryString.append(" LEFT JOIN UserRole l ON e.id = l.userId");
            if (this.exclusiveRoleId != null) {
                queryString.append(" AND l.roleId = :exclusiveRoleId");
            }
            if (this.exclusiveRoleIds != null) {
                queryString.append(" AND l.roleId IN :exclusiveRoleIds");
            }
            if (this.exclusiveRoleName != null || this.exclusiveRoleNames != null) {
                queryString.append(" LEFT JOIN UserRoleName m ON m.id = l.roleId");
                if (this.exclusiveRoleName != null) {
                    queryString.append(" AND m.name = :exclusiveRoleName");
                }
                if (this.exclusiveRoleNames != null) {
                    queryString.append(" AND m.name IN :exclusiveRoleNames");
                }
            }
        }
    }

    public String matchingCondition() {
        EzyQueryConditionBuilder answer = new EzyQueryConditionBuilder();
        if (this.status != null) {
            answer.and("e.status = :status");
        }
        if (this.statuses != null) {
            answer.and("e.status in :statuses");
        }
        if (this.keywords != null) {
            answer.and("k.keyword IN :keywords");
        }
        if (this.roleId != null) {
            answer.and("l.roleId = :roleId");
        }
        if (this.roleIds != null) {
            answer.and("l.roleId IN :roleIds");
        }
        if (this.roleName != null) {
            answer.and("m.name = :roleName");
        }
        if (this.roleNames != null) {
            answer.and("m.name IN :roleNames");
        }
        if (this.exclusiveRoleId != null || this.exclusiveRoleIds != null) {
            answer.and("l.roleId IS NULL");
        }
        if (this.exclusiveRoleName != null || this.exclusiveRoleNames != null) {
            answer.and("m.id IS NULL");
        }
        if (this.uniqueKeyword != null) {
            answer.and(new EzyQueryConditionBuilder().append("(").append("e.username = :uniqueKeyword").or("e.phone = :uniqueKeyword").or("e.email = :uniqueKeyword").or("e.uuid = :uniqueKeyword").or("e.id = :uniqueKeyword").append(")").build());
        }
        if (this.likeKeyword != null) {
            answer.and(new EzyQueryConditionBuilder().append("(").append("e.phone LIKE CONCAT('%',:likeKeyword,'%')").or("e.email LIKE CONCAT('%',:likeKeyword,'%')").or("e.displayName LIKE CONCAT('%',:likeKeyword,'%')").or("e.username LIKE CONCAT('%',:likeKeyword,'%')").append(")").build());
        }
        return answer.build();
    }

    public static class Builder<T extends Builder<T>>
    implements EzyBuilder<DefaultUserFilter> {
        private String status;
        private Collection<String> statuses;
        private String uniqueKeyword;
        private String likeKeyword;
        private Collection<String> keywords;
        private Long roleId;
        private Collection<Long> roleIds;
        private String roleName;
        private Collection<String> roleNames;
        private Long exclusiveRoleId;
        private Collection<Long> exclusiveRoleIds;
        private String exclusiveRoleName;
        private Collection<String> exclusiveRoleNames;

        public T status(String status) {
            this.status = status;
            return (T)this;
        }

        public T statuses(Collection<String> statuses) {
            this.statuses = statuses;
            return (T)this;
        }

        public T uniqueKeyword(String uniqueKeyword) {
            this.uniqueKeyword = uniqueKeyword;
            return (T)this;
        }

        public T likeKeyword(String likeKeyword) {
            this.likeKeyword = likeKeyword;
            return (T)this;
        }

        public T keywords(Collection<String> keywords) {
            this.keywords = keywords;
            return (T)this;
        }

        public T roleId(Long roleId) {
            this.roleId = roleId;
            return (T)this;
        }

        public T roleIds(Collection<Long> roleIds) {
            this.roleIds = roleIds;
            return (T)this;
        }

        public T roleName(String roleName) {
            this.roleName = roleName;
            return (T)this;
        }

        public T roleNames(Collection<String> roleNames) {
            this.roleNames = roleNames;
            return (T)this;
        }

        public T exclusiveRoleId(Long exclusiveRoleId) {
            this.exclusiveRoleId = exclusiveRoleId;
            return (T)this;
        }

        public T exclusiveRoleIds(Collection<Long> exclusiveRoleIds) {
            this.exclusiveRoleIds = exclusiveRoleIds;
            return (T)this;
        }

        public T exclusiveRoleName(String exclusiveRoleName) {
            this.exclusiveRoleName = exclusiveRoleName;
            return (T)this;
        }

        public T exclusiveRoleNames(Collection<String> exclusiveRoleNames) {
            this.exclusiveRoleNames = exclusiveRoleNames;
            return (T)this;
        }

        public DefaultUserFilter build() {
            return new DefaultUserFilter(this);
        }
    }
}

