/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.appender;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tvd12.ezyfox.util.Next;
import java.time.LocalDateTime;
import java.util.List;
import org.youngmonkeys.ezyplatform.admin.appender.AdminLastUpdatedAtLinkAppender;
import org.youngmonkeys.ezyplatform.admin.repo.AdminLinkRepository;
import org.youngmonkeys.ezyplatform.admin.repo.AdminUserRepository;
import org.youngmonkeys.ezyplatform.admin.service.AdminSettingService;
import org.youngmonkeys.ezyplatform.entity.Link;
import org.youngmonkeys.ezyplatform.entity.User;
import org.youngmonkeys.ezyplatform.pagination.LastUpdatedAtPageToken;
import org.youngmonkeys.ezyplatform.result.UpdatedAtValueResult;
import org.youngmonkeys.ezyplatform.time.ClockProxy;
import org.youngmonkeys.ezyplatform.util.Strings;

public class AdminUserLinkAppender
extends AdminLastUpdatedAtLinkAppender<User> {
    private final String linkType;
    private final String rootLinkUri;
    private final ClockProxy clock;
    private final AdminUserRepository userRepository;

    public AdminUserLinkAppender(String linkType, String rootLinkUri, ClockProxy clock, ObjectMapper objectMapper, AdminSettingService settingService, AdminLinkRepository linkRepository, AdminUserRepository userRepository) {
        super(clock, objectMapper, settingService, linkRepository);
        this.linkType = linkType;
        this.rootLinkUri = rootLinkUri;
        this.clock = clock;
        this.userRepository = userRepository;
    }

    @Override
    protected List<User> getValueList(LastUpdatedAtPageToken pageToken) {
        return this.userRepository.findActivatedUsersByUpdatedAtAndIdPaginationAsc(pageToken.getUpdatedAt(), pageToken.getIdNumber(), Next.limit((long)pageToken.getLimit()));
    }

    @Override
    protected Link toLink(User value) {
        Link link = new Link();
        link.setLinkType(this.linkType);
        link.setLinkUri("/" + this.rootLinkUri + "/" + value.getUuid());
        link.setImageId(value.getAvatarImageId());
        link.setDescription(Strings.emptyIfNull((String)value.getDisplayName()));
        link.setSourceType("USER");
        link.setSourceId(value.getId());
        return link;
    }

    @Override
    protected LocalDateTime extractLastUpdatedAt(User value) {
        return value.getUpdatedAt();
    }

    @Override
    protected Object extractLastId(User value) {
        return value.getId();
    }

    @Override
    protected LocalDateTime firstUpdatedAt() {
        return this.clock.nowDateTimeIfNull(UpdatedAtValueResult.updatedAtOrNull((UpdatedAtValueResult)this.userRepository.findFirstUpdatedAt()));
    }

    @Override
    protected String getAppenderNamePrefix() {
        return "ezylink_user";
    }
}

