/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.controller.decorator;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.youngmonkeys.ezyplatform.model.AdminAccessTokenModel;

public final class AdminLoginResponseDecorators {
    private AdminLoginResponseDecorators() {
    }

    public static void decorateToAddAdminAccessToken(HttpServletResponse response, AdminAccessTokenModel accessToken) {
        response.addCookie(AdminLoginResponseDecorators.newAccessTokenCookie("adminAccessToken", accessToken));
        response.addCookie(AdminLoginResponseDecorators.newAccessTokenExpiredAtCookie("adminAccessTokenExpiredAt", accessToken));
    }

    public static Cookie newAccessTokenCookie(String cookieName, AdminAccessTokenModel accessToken) {
        Cookie accessTokenCookie = new Cookie(cookieName, accessToken.getAccessToken());
        accessTokenCookie.setPath("/");
        accessTokenCookie.setMaxAge(accessToken.getMaxAge());
        return accessTokenCookie;
    }

    public static Cookie newAccessTokenExpiredAtCookie(String cookieName, AdminAccessTokenModel accessToken) {
        Cookie accessTokenExpiredAtCookie = new Cookie(cookieName, String.valueOf(accessToken.getExpiredAtTimestamp()));
        accessTokenExpiredAtCookie.setPath("/");
        accessTokenExpiredAtCookie.setMaxAge(accessToken.getMaxAge());
        return accessTokenExpiredAtCookie;
    }
}

