/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.service;

import com.tvd12.ezyhttp.server.core.annotation.Service;
import com.tvd12.properties.file.reader.FileReader;
import java.util.Collection;
import java.util.Properties;
import java.util.TreeMap;
import org.youngmonkeys.ezyplatform.admin.model.AdminLanguageModel;
import org.youngmonkeys.ezyplatform.admin.service.AdminSettingService;
import org.youngmonkeys.ezyplatform.service.LanguageService;

@Service
public class AdminLanguageService
implements LanguageService {
    private final FileReader propertiesFileReader;
    private final AdminSettingService settingService;
    private final TreeMap<String, AdminLanguageModel> languageByCode = new TreeMap();

    public AdminLanguageService(FileReader propertiesFileReader, AdminSettingService settingService) {
        this.settingService = settingService;
        this.propertiesFileReader = propertiesFileReader;
        this.load();
    }

    private void load() {
        Properties properties = this.propertiesFileReader.read("languages.properties");
        for (String code : properties.stringPropertyNames()) {
            String details = properties.getProperty(code);
            this.languageByCode.put(code, AdminLanguageModel.parse(code, details));
        }
    }

    public boolean containsLanguage(String languageCode) {
        return this.languageByCode.containsKey(languageCode);
    }

    public Collection<AdminLanguageModel> getLanguages() {
        return this.languageByCode.values();
    }

    public void setDefaultLanguageCode(String languageCode) {
        this.settingService.setTextValue("admin_default_language", languageCode);
    }

    public String getDefaultLanguageCode() {
        return this.settingService.getTextValue("admin_default_language");
    }
}

