/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.cli.util;

import com.tvd12.ezyfox.function.EzyExceptionApply;
import com.tvd12.ezyfox.function.EzyExceptionFunction;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.properties.file.reader.BaseFileReader;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;

public final class DatabaseConnectonProxy {
    private Properties properties;
    private static final DatabaseConnectonProxy INSTANCE = new DatabaseConnectonProxy();

    private DatabaseConnectonProxy() {
    }

    public static DatabaseConnectonProxy getInstance() {
        return INSTANCE;
    }

    public void execute(EzyExceptionApply<Connection> script) throws Exception {
        try (Connection connection = this.getConnection();){
            script.apply((Object)connection);
        }
    }

    public <T> T submit(EzyExceptionFunction<Connection, T> script) throws Exception {
        try (Connection connection = this.getConnection();){
            Object object = script.apply((Object)connection);
            return (T)object;
        }
    }

    private Connection getConnection() throws Exception {
        if (this.properties == null) {
            this.properties = this.readSetupFile();
        }
        String driver = this.properties.getProperty("datasource.driver_class_name");
        String jdbcUrl = this.properties.getProperty("datasource.jdbc_url");
        String username = this.properties.getProperty("datasource.username");
        String password = this.properties.getProperty("datasource.password");
        Class.forName(driver);
        return EzyStrings.isNoContent((String)username) || EzyStrings.isNoContent((String)password) ? DriverManager.getConnection(jdbcUrl) : DriverManager.getConnection(jdbcUrl, username, password);
    }

    public String getDatabaseName() {
        if (this.properties == null) {
            this.properties = this.readSetupFile();
        }
        String jdbcUrl = this.properties.getProperty("datasource.jdbc_url");
        int startFromIndex = jdbcUrl.indexOf("://");
        int index = jdbcUrl.indexOf(47, startFromIndex + 3);
        int toIndex = jdbcUrl.indexOf(63);
        return jdbcUrl.substring(index + 1, toIndex < 0 ? jdbcUrl.length() : toIndex);
    }

    private Properties readSetupFile() {
        return new BaseFileReader().read(Paths.get("settings", "setup.properties").toFile());
    }
}

