/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.stream;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class EzyFileListInputStream
extends InputStream {
    private final List<File> files;
    private int currentFileIndex;
    private InputStream currentStream;
    private volatile boolean closed;
    private volatile boolean done;

    public EzyFileListInputStream(List<File> files) {
        if (files.isEmpty()) {
            throw new IllegalArgumentException("file list is empty");
        }
        this.files = files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        while (true) {
            EzyFileListInputStream ezyFileListInputStream = this;
            synchronized (ezyFileListInputStream) {
                int b;
                if (this.closed) {
                    throw new IOException("stream closed");
                }
                if (this.done) {
                    return -1;
                }
                if (this.currentStream == null) {
                    this.currentStream = new FileInputStream(this.files.get(this.currentFileIndex));
                }
                if ((b = this.currentStream.read()) > 0) {
                    return b;
                }
                this.currentStream.close();
                this.currentStream = null;
                if (++this.currentFileIndex >= this.files.size()) {
                    this.done = true;
                    return -1;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        EzyFileListInputStream ezyFileListInputStream = this;
        synchronized (ezyFileListInputStream) {
            this.closed = true;
            if (this.currentStream != null) {
                this.currentStream.close();
                this.currentStream = null;
            }
        }
    }
}

