/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.validator;

import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.util.EzyFileUtil;
import com.tvd12.ezyhttp.core.constant.ContentType;
import com.tvd12.ezyhttp.core.exception.HttpBadRequestException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.http.Part;
import lombok.Generated;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.youngmonkeys.ezyplatform.constant.CommonConstants;
import org.youngmonkeys.ezyplatform.data.FileMetadata;
import org.youngmonkeys.ezyplatform.exception.ResourceNotFoundException;
import org.youngmonkeys.ezyplatform.model.MediaModel;
import org.youngmonkeys.ezyplatform.request.AddMediaFromUrlRequest;
import org.youngmonkeys.ezyplatform.request.UpdateMediaIncludeUrlRequest;
import org.youngmonkeys.ezyplatform.request.UpdateMediaRequest;
import org.youngmonkeys.ezyplatform.service.MediaService;
import org.youngmonkeys.ezyplatform.service.SettingService;
import org.youngmonkeys.ezyplatform.validator.DefaultValidator;

public class MediaValidator {
    private final TikaConfig tika;
    private final MediaService mediaService;
    private final SettingService settingService;

    public MediaModel validateMediaId(long mediaId) {
        MediaModel media = this.mediaService.getMediaById(mediaId);
        if (media == null) {
            throw new ResourceNotFoundException("media");
        }
        return media;
    }

    public MediaModel validateUserMedia(long mediaId, long userId) {
        MediaModel media = this.validateMediaId(mediaId);
        if (media.getOwnerUserId() != userId) {
            throw new ResourceNotFoundException("media");
        }
        return media;
    }

    public void validateMediaName(String mediaName) {
        HashMap<String, String> errors = new HashMap<String, String>();
        if (!DefaultValidator.isValidMediaName((String)mediaName)) {
            errors.put("mediaName", "invalid");
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public FileMetadata validateFilePart(Part filePart, boolean avatar) throws IOException {
        long fileSize = 0L;
        String extension = null;
        String mimeType = null;
        MediaType mediaType = null;
        HashMap<String, String> errors = new HashMap<String, String>();
        if (filePart == null) {
            errors.put("file", "invalid");
        } else {
            String fileName = filePart.getSubmittedFileName();
            if (EzyStrings.isNoContent((String)fileName)) {
                errors.put("fileName", "invalid");
            }
            if (EzyStrings.isNoContent((String)(extension = EzyFileUtil.getFileExtension((String)fileName)))) {
                errors.put("fileType", "invalid");
            }
            if ((fileSize = filePart.getSize()) > this.settingService.getMaxUploadFileSize()) {
                errors.put("uploadSize", "over");
            }
            try (TikaInputStream tikaInputStream = TikaInputStream.get((InputStream)filePart.getInputStream());){
                Metadata metadata = new Metadata();
                metadata.set("resourceName", fileName);
                mediaType = this.tika.getDetector().detect((InputStream)tikaInputStream, metadata);
            }
            mimeType = mediaType.toString();
            Set acceptedMediaMimeTypes = this.settingService.getAcceptedMediaMimeTypes();
            if (!acceptedMediaMimeTypes.contains(mimeType) && !acceptedMediaMimeTypes.contains("*")) {
                errors.put("fileType", "invalid");
            }
            if (avatar && !CommonConstants.DEFAULT_ACCEPTED_IMAGE_TYPES.contains(mediaType.toString())) {
                errors.put("fileType", "invalid");
            }
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
        return FileMetadata.builder().mimeType(mimeType).fileSize(fileSize).extension(ContentType.getExtensionOfMimeType(mimeType, (String)extension)).mediaType(avatar ? org.youngmonkeys.ezyplatform.entity.MediaType.AVATAR : org.youngmonkeys.ezyplatform.entity.MediaType.ofMimeTypeName((String)mediaType.getType())).build();
    }

    public void validate(AddMediaFromUrlRequest request) {
        String originalName;
        HashMap<String, String> errors = new HashMap<String, String>();
        org.youngmonkeys.ezyplatform.entity.MediaType type = request.getType();
        if (type == null) {
            errors.put("type", "required");
        }
        if (EzyStrings.isBlank((String)(originalName = request.getOriginalName()))) {
            errors.put("originalName", "required");
        } else if (originalName.length() > 300) {
            errors.put("originalName", "overLength");
        }
        String url = request.getUrl();
        if (EzyStrings.isBlank((String)url)) {
            errors.put("url", "required");
        } else if (url.length() > 300) {
            errors.put("url", "overLength");
        } else if (!DefaultValidator.isValidUrl((String)url)) {
            errors.put("url", "invalid");
        }
        BigDecimal durationInMinutes = request.getDurationInMinutes();
        if (durationInMinutes != null && durationInMinutes.compareTo(BigDecimal.ZERO) < 0) {
            errors.put("durationInMinutes", "invalid");
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(UpdateMediaRequest request) {
        String description;
        String caption;
        String title;
        HashMap<String, String> errors = new HashMap<String, String>();
        String alternativeText = request.getAlternativeText();
        if (alternativeText != null && alternativeText.length() > 300) {
            errors.put("alternativeText", "overLength");
        }
        if ((title = request.getTitle()) != null && title.length() > 300) {
            errors.put("title", "overLength");
        }
        if ((caption = request.getCaption()) != null && caption.length() > 300) {
            errors.put("caption", "overLength");
        }
        if ((description = request.getDescription()) != null && description.length() > 3500) {
            errors.put("description", "overLength");
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(UpdateMediaIncludeUrlRequest request) {
        BigDecimal durationInMinutes;
        String url;
        String description;
        String caption;
        String title;
        HashMap<String, String> errors = new HashMap<String, String>();
        String alternativeText = request.getAlternativeText();
        if (alternativeText != null && alternativeText.length() > 300) {
            errors.put("alternativeText", "overLength");
        }
        if ((title = request.getTitle()) != null && title.length() > 300) {
            errors.put("title", "overLength");
        }
        if ((caption = request.getCaption()) != null && caption.length() > 300) {
            errors.put("caption", "overLength");
        }
        if ((description = request.getDescription()) != null && description.length() > 3500) {
            errors.put("description", "overLength");
        }
        if (EzyStrings.isNotBlank((String)(url = request.getUrl()))) {
            if (url.length() > 300) {
                errors.put("url", "overLength");
            } else if (!DefaultValidator.isValidUrl((String)url)) {
                errors.put("url", "invalid");
            }
        }
        if (request.isUpdateDuration() && (durationInMinutes = request.getDurationInMinutes()) != null && durationInMinutes.compareTo(BigDecimal.ZERO) < 0) {
            errors.put("durationInMinutes", "invalid");
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    @Generated
    public MediaValidator(TikaConfig tika, MediaService mediaService, SettingService settingService) {
        this.tika = tika;
        this.mediaService = mediaService;
        this.settingService = settingService;
    }
}

